/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.repeater;

import java.util.Comparator;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.version.undo.Change;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Item<T>
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private int index;

    public Item(String id, int index, IModel<T> model) {
        super(id.intern(), model);
        this.index = index;
    }

    public Item(String id, int index) {
        super(id.intern());
        this.index = index;
    }

    public void setIndex(int index) {
        if (this.index != index) {
            if (this.isVersioned()) {
                this.addStateChange(new Change(){
                    final int oldIndex;
                    private static final long serialVersionUID = 1L;
                    {
                        this.oldIndex = Item.this.index;
                    }

                    public void undo() {
                        Item.this.index = this.oldIndex;
                    }

                    public String toString() {
                        return "IndexChange[component: " + Item.this.getPath() + ", index: " + this.oldIndex + "]";
                    }
                });
            }
            this.index = index;
        }
    }

    public int getIndex() {
        return this.index;
    }

    public String getPrimaryKey() {
        return this.getId();
    }

    public final IModel<T> getModel() {
        return this.getDefaultModel();
    }

    public final void setModel(IModel<T> model) {
        this.setDefaultModel((IModel)model);
    }

    public final T getModelObject() {
        return (T)this.getDefaultModelObject();
    }

    public final void setModelObject(T object) {
        this.setDefaultModelObject(object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IndexComparator
    implements Comparator<Item<?>> {
        private static final Comparator<Item<?>> instance = new IndexComparator();

        public static final Comparator<Item<?>> getInstance() {
            return instance;
        }

        @Override
        public int compare(Item<?> lhs, Item<?> rhs) {
            return lhs.getIndex() - rhs.getIndex();
        }
    }
}

