/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.repeater;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepeater
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(AbstractRepeater.class);
    private static Pattern SAFE_CHILD_ID_PATTERN = Pattern.compile("^\\d+$");

    public AbstractRepeater(String id) {
        super(id);
    }

    public AbstractRepeater(String id, IModel<?> model) {
        super(id, model);
    }

    protected abstract Iterator<? extends Component> renderIterator();

    @Override
    protected final void onRender(MarkupStream markupStream) {
        int markupStart = markupStream.getCurrentIndex();
        Iterator<? extends Component> it = this.renderIterator();
        if (it.hasNext()) {
            do {
                Component child;
                if ((child = it.next()) == null) {
                    throw new IllegalStateException("the render iterator returned null for a child");
                }
                markupStream.setCurrentIndex(markupStart);
                this.renderChild(child);
            } while (it.hasNext());
        } else {
            markupStream.skipComponent();
        }
    }

    protected void renderChild(Component child) {
        child.render(this.getMarkupStream());
    }

    @Override
    protected void onBeforeRender() {
        this.onPopulate();
        if (Application.get().getConfigurationType().equals("development")) {
            Iterator<? extends Component> i = this.iterator();
            while (i.hasNext()) {
                Component c = i.next();
                Matcher matcher = SAFE_CHILD_ID_PATTERN.matcher(c.getId());
                if (matcher.matches()) continue;
                log.warn("Child component of repeater " + this.getClass().getName() + ":" + this.getId() + " has a non-safe child id of " + c.getId() + ". Safe child ids must be composed of digits only.");
                break;
            }
        }
        super.onBeforeRender();
    }

    protected abstract void onPopulate();
}

