/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.wicket.IClusterable;
import org.apache.wicket.markup.html.tree.ITreeState;
import org.apache.wicket.markup.html.tree.ITreeStateListener;
import org.apache.wicket.model.IDetachable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTreeState
implements ITreeState,
IClusterable,
IDetachable {
    private static final long serialVersionUID = 1L;
    private boolean allowSelectMultiple = false;
    private final List<ITreeStateListener> listeners = new ArrayList<ITreeStateListener>(1);
    private final Set<Object> nodes = new HashSet<Object>();
    private boolean nodesCollapsed = false;
    private final Set<Object> selectedNodes = new HashSet<Object>();

    @Override
    public void addTreeStateListener(ITreeStateListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void collapseAll() {
        if (!this.nodes.isEmpty() || this.nodesCollapsed) {
            this.nodes.clear();
            this.nodesCollapsed = false;
            Object[] listenersCopy = this.listeners.toArray();
            for (int i = 0; i < listenersCopy.length; ++i) {
                ITreeStateListener l = (ITreeStateListener)listenersCopy[i];
                l.allNodesCollapsed();
            }
        }
    }

    @Override
    public void collapseNode(Object node) {
        if (this.nodesCollapsed) {
            this.nodes.add(node);
        } else {
            this.nodes.remove(node);
        }
        Object[] listenersCopy = this.listeners.toArray();
        for (int i = 0; i < listenersCopy.length; ++i) {
            ITreeStateListener l = (ITreeStateListener)listenersCopy[i];
            l.nodeCollapsed(node);
        }
    }

    @Override
    public void expandAll() {
        if (!this.nodes.isEmpty() || !this.nodesCollapsed) {
            this.nodes.clear();
            this.nodesCollapsed = true;
            Object[] listenersCopy = this.listeners.toArray();
            for (int i = 0; i < listenersCopy.length; ++i) {
                ITreeStateListener l = (ITreeStateListener)listenersCopy[i];
                l.allNodesExpanded();
            }
        }
    }

    @Override
    public void expandNode(Object node) {
        if (!this.nodesCollapsed) {
            this.nodes.add(node);
        } else {
            this.nodes.remove(node);
        }
        Object[] listenersCopy = this.listeners.toArray();
        for (int i = 0; i < listenersCopy.length; ++i) {
            ITreeStateListener l = (ITreeStateListener)listenersCopy[i];
            l.nodeExpanded(node);
        }
    }

    @Override
    public Collection<Object> getSelectedNodes() {
        return Collections.unmodifiableList(new ArrayList<Object>(this.selectedNodes));
    }

    protected void removeSelectedNodeSilent(Object node) {
        this.selectedNodes.remove(node);
    }

    @Override
    public boolean isAllowSelectMultiple() {
        return this.allowSelectMultiple;
    }

    @Override
    public boolean isNodeExpanded(Object node) {
        if (!this.nodesCollapsed) {
            return this.nodes.contains(node);
        }
        return !this.nodes.contains(node);
    }

    @Override
    public boolean isNodeSelected(Object node) {
        return this.selectedNodes.contains(node);
    }

    @Override
    public void removeTreeStateListener(ITreeStateListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void selectNode(Object node, boolean selected) {
        block6: {
            ITreeStateListener l;
            Object[] listenersCopy;
            block5: {
                if (!this.isAllowSelectMultiple() && this.selectedNodes.size() > 0) {
                    Iterator<Object> i = this.selectedNodes.iterator();
                    while (i.hasNext()) {
                        Object current = i.next();
                        if (current.equals(node)) continue;
                        i.remove();
                        Object[] listenersCopy2 = this.listeners.toArray();
                        for (int j = 0; j < listenersCopy2.length; ++j) {
                            ITreeStateListener l2 = (ITreeStateListener)listenersCopy2[j];
                            l2.nodeUnselected(current);
                        }
                    }
                }
                if (!selected || this.selectedNodes.contains(node)) break block5;
                this.selectedNodes.add(node);
                listenersCopy = this.listeners.toArray();
                for (int i = 0; i < listenersCopy.length; ++i) {
                    l = (ITreeStateListener)listenersCopy[i];
                    l.nodeSelected(node);
                }
                break block6;
            }
            if (selected || !this.selectedNodes.contains(node)) break block6;
            this.selectedNodes.remove(node);
            listenersCopy = this.listeners.toArray();
            for (int i = 0; i < listenersCopy.length; ++i) {
                l = (ITreeStateListener)listenersCopy[i];
                l.nodeUnselected(node);
            }
        }
    }

    @Override
    public void setAllowSelectMultiple(boolean value) {
        this.allowSelectMultiple = value;
    }

    @Override
    public void detach() {
        for (Object node : this.nodes) {
            if (!(node instanceof IDetachable)) continue;
            ((IDetachable)node).detach();
        }
        for (Object node : this.selectedNodes) {
            if (!(node instanceof IDetachable)) continue;
            ((IDetachable)node).detach();
        }
    }
}

