/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.link;

import org.apache.wicket.IResourceListener;
import org.apache.wicket.Resource;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.util.value.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLink<T>
extends Link<T>
implements IResourceListener {
    private static final long serialVersionUID = 1L;
    private final ResourceReference resourceReference;
    private final Resource resource;
    private final ValueMap resourceParameters;

    public ResourceLink(String id, ResourceReference resourceReference) {
        this(id, resourceReference, null);
    }

    public ResourceLink(String id, ResourceReference resourceReference, ValueMap resourceParameters) {
        super(id);
        this.resourceReference = resourceReference;
        this.resourceParameters = resourceParameters;
        this.resource = null;
    }

    public ResourceLink(String id, Resource resource) {
        super(id);
        this.resource = resource;
        this.resourceReference = null;
        this.resourceParameters = null;
    }

    @Override
    public void onClick() {
    }

    @Override
    public final void onResourceRequested() {
        this.resource.onResourceRequested();
        this.onClick();
    }

    @Override
    protected final CharSequence getURL() {
        if (this.resourceReference != null) {
            this.resourceReference.bind(this.getApplication());
            return this.getRequestCycle().urlFor(this.resourceReference, this.resourceParameters);
        }
        return this.urlFor(IResourceListener.INTERFACE);
    }
}

