/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form.upload;

import org.apache.wicket.Request;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.IMultipartWebRequest;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.upload.FileItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUploadField
extends FormComponent<FileUpload> {
    private static final long serialVersionUID = 1L;
    private transient FileUpload fileUpload;

    public FileUploadField(String id) {
        super(id);
    }

    public FileUploadField(String id, IModel<FileUpload> model) {
        super(id, model);
    }

    public FileUpload getFileUpload() {
        FileItem item;
        Request request = this.getRequest();
        if (request instanceof IMultipartWebRequest && (item = ((IMultipartWebRequest)((Object)request)).getFile(this.getInputName())) != null && item.getSize() > 0L) {
            if (this.fileUpload == null) {
                this.fileUpload = new FileUpload(item);
            }
            return this.fileUpload;
        }
        return null;
    }

    @Override
    public void updateModel() {
        if (this.getModel() != null) {
            super.updateModel();
        }
    }

    @Override
    public FileUploadField setDefaultModel(IModel<?> model) {
        return (FileUploadField)super.setDefaultModel((IModel)model);
    }

    @Override
    public String[] getInputAsArray() {
        FileUpload fu = this.getFileUpload();
        if (fu != null) {
            return new String[]{fu.getClientFileName()};
        }
        return null;
    }

    @Override
    protected FileUpload convertValue(String[] value) throws ConversionException {
        String[] filenames = this.getInputAsArray();
        if (filenames == null) {
            return null;
        }
        return this.getFileUpload();
    }

    @Override
    public boolean isMultiPart() {
        return true;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "input");
        this.checkComponentTagAttribute(tag, "type", "file");
        super.onComponentTag(tag);
    }

    @Override
    protected boolean supportsPersistence() {
        return false;
    }

    @Override
    protected void onDetach() {
        if (this.fileUpload != null && this.forceCloseStreamsOnDetach()) {
            this.fileUpload.closeStreams();
            this.fileUpload = null;
            if (this.getModel() != null) {
                this.setModelObject(null);
            }
        }
        super.onDetach();
    }

    protected boolean forceCloseStreamsOnDetach() {
        return true;
    }
}

