/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.ContainerWithAssociatedMarkupHelper;
import org.apache.wicket.markup.html.HeaderPartContainer;
import org.apache.wicket.markup.html.IHeaderPartContainerProvider;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.markup.parser.filter.WicketTagIdentifier;
import org.apache.wicket.model.IModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FormComponentPanel<T>
extends FormComponent<T>
implements IHeaderPartContainerProvider {
    private static final long serialVersionUID = 1L;
    private ContainerWithAssociatedMarkupHelper markupHelper;
    private boolean wasOpenCloseTag = false;

    public FormComponentPanel(String id) {
        super(id);
    }

    public FormComponentPanel(String id, IModel<T> model) {
        super(id, model);
    }

    @Override
    public boolean checkRequired() {
        return true;
    }

    @Override
    public HeaderPartContainer newHeaderPartContainer(String id, String scope) {
        return new HeaderPartContainer(id, this, scope);
    }

    @Override
    public void renderHead(HtmlHeaderContainer container) {
        if (this.markupHelper == null) {
            this.markupHelper = new ContainerWithAssociatedMarkupHelper(this);
        }
        this.markupHelper.renderHeadFromAssociatedMarkupFile(container);
        super.renderHead(container);
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        if (tag.isOpenClose()) {
            this.wasOpenCloseTag = true;
            tag.setType(XmlTag.OPEN);
        }
        super.onComponentTag(tag);
        tag.remove("name");
        tag.remove("disabled");
    }

    @Override
    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        this.renderAssociatedMarkup("panel", "Markup for a panel component has to contain part '<wicket:panel>'");
        if (!this.wasOpenCloseTag) {
            markupStream.skipRawMarkup();
        }
    }

    static {
        WicketTagIdentifier.registerWellKnownTagName("panel");
    }
}

