/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.behavior;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.AbstractHeaderContributor;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringHeaderContributor
extends AbstractHeaderContributor {
    private static final long serialVersionUID = 1L;
    private final StringContributor contributor;

    public StringHeaderContributor(String contribution) {
        this.contributor = new StringContributor(contribution);
    }

    public StringHeaderContributor(IModel<?> contribution) {
        this.contributor = new StringContributor(contribution);
    }

    @Override
    public final IHeaderContributor[] getHeaderContributors() {
        return new IHeaderContributor[]{this.contributor};
    }

    @Override
    public void detach(Component component) {
        this.contributor.contribution.detach();
    }

    public String toString() {
        Object string = this.contributor.contribution.getObject();
        return string != null ? string.toString() : "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StringContributor
    implements IHeaderContributor {
        private static final long serialVersionUID = 1L;
        private final IModel<?> contribution;

        public StringContributor(String contribution) {
            if (contribution == null) {
                throw new IllegalArgumentException("argument contribition must be not null");
            }
            this.contribution = new Model<String>(contribution);
        }

        public StringContributor(IModel<?> contribution) {
            if (contribution == null) {
                throw new IllegalArgumentException("argument contribition must be not null");
            }
            this.contribution = contribution;
        }

        @Override
        public void renderHead(IHeaderResponse response) {
            Object object = this.contribution.getObject();
            if (object != null) {
                response.getResponse().println(object.toString());
            }
        }

        public int hashCode() {
            Object object = this.contribution.getObject();
            return object != null ? object.hashCode() : 0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof StringContributor) {
                Object thisContrib = this.contribution.getObject();
                Object thatContrib = ((StringContributor)obj).contribution.getObject();
                return Objects.equal(thisContrib, thatContrib);
            }
            return false;
        }

        public String toString() {
            return "StringContributor[contribution=" + this.contribution + "]";
        }
    }
}

