/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.util.Iterator;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.IComponentSource;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ComponentSourceEntry
implements IClusterable {
    private static final long serialVersionUID = 1L;
    final String id;
    private final IComponentSource componentSource;
    private final String componentInfo;
    private static final Logger logger = LoggerFactory.getLogger(ComponentSourceEntry.class);

    private final void checkId(String name, String id) {
        if (id.indexOf(40) != -1 || id.indexOf(40) != -1 || id.indexOf(32) != -1 || id.indexOf(44) != -1) {
            throw new IllegalStateException(name + "'" + id + "' is not valid, it may not contain any of the ' ', '(', ')', ',' characters");
        }
    }

    private final void appendComponent(AppendingStringBuffer buffer, Component component) {
        this.checkId("Component id", component.getId());
        buffer.append(component.getId());
        buffer.append(' ');
        Object markupId = component.getMarkupIdImpl();
        if (markupId != null) {
            if (markupId instanceof String) {
                this.checkId("Component markup id", (String)markupId);
            }
            if (markupId instanceof Integer) {
                buffer.append('*');
            }
            buffer.append(markupId);
            buffer.append(' ');
        }
        buffer.append(component.markupIndex);
        if (component instanceof MarkupContainer && ((MarkupContainer)component).iterator().hasNext()) {
            buffer.append('(');
            Iterator<? extends Component> i = ((MarkupContainer)component).iterator();
            while (i.hasNext()) {
                Component child = i.next();
                this.appendComponent(buffer, child);
                if (!i.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append(')');
        }
    }

    ComponentSourceEntry(MarkupContainer container, Component component, IComponentSource componentSource) {
        this.id = component.getId();
        this.componentSource = componentSource;
        AppendingStringBuffer buffer = new AppendingStringBuffer();
        this.appendComponent(buffer, component);
        this.componentInfo = buffer.toString();
        System.out.println("Info: " + this.componentInfo);
    }

    protected abstract void setChild(MarkupContainer var1, int var2, Component var3);

    Component reconstruct(MarkupContainer parent, int index) {
        Component component = this.componentSource.restoreComponent(this.id);
        if (parent != null) {
            component.setParent(parent);
        }
        component.beforeRender();
        ComponentSourceEntry.parseComponentInfo(parent, this.componentInfo, component);
        return component;
    }

    private static String getComponentSubString(String string) {
        int len = string.length();
        int i = string.indexOf(44);
        if (i != -1 && i < len) {
            len = i;
        }
        if ((i = string.indexOf(41)) != -1 && i < len) {
            len = i;
        }
        if ((i = string.substring(0, len).indexOf(40)) != -1 && i < len) {
            len = i;
        }
        return string.substring(0, len);
    }

    private static MarkupContainer applyComponentInfo(MarkupContainer parent, String info, Component component) {
        int markupIndex;
        Object markupId;
        if (parent == null) {
            return null;
        }
        String[] parts = info.split(" ");
        String id = parts[0];
        if (parts.length == 2) {
            markupId = null;
            markupIndex = Integer.parseInt(parts[1]);
        } else if (parts.length == 3) {
            markupId = parts[1] != null && parts[1].startsWith("*") ? Integer.valueOf(parts[1].substring(1)) : parts[1];
            markupIndex = Integer.parseInt(parts[2]);
        } else {
            throw new IllegalArgumentException("Malformed component info string '" + info + "'.");
        }
        if (component == null) {
            component = parent.get(id);
        }
        if (component == null) {
            logger.warn("Couldn't find component with id '" + id + "'. This means that the component was not properly reconstructed from ComponentSource.");
        } else {
            if (markupId != null) {
                component.setMarkupIdImpl(markupId);
            }
            component.markupIndex = (short)markupIndex;
        }
        return component instanceof MarkupContainer ? (MarkupContainer)component : null;
    }

    private static int parseComponentInfo(MarkupContainer parent, String info, Component component) {
        String substring = ComponentSourceEntry.getComponentSubString(info);
        int len = substring.length();
        boolean hasChildren = false;
        if (len < info.length() && info.charAt(len) == '(') {
            hasChildren = true;
            ++len;
        }
        MarkupContainer child = ComponentSourceEntry.applyComponentInfo(parent, substring, component);
        if (hasChildren) {
            int i = 0;
            String children = info.substring(len);
            while (i < children.length()) {
                if (children.charAt(i) == ',') {
                    ++i;
                }
                if (children.charAt(i += ComponentSourceEntry.parseComponentInfo(child, children.substring(i), null)) != ')') continue;
                ++i;
                break;
            }
            return len + i;
        }
        return len;
    }
}

