/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.protocol.v11;

import com.funambol.framework.core.Alert;
import com.funambol.framework.core.CmdID;
import com.funambol.framework.core.Constants;
import com.funambol.framework.core.Item;
import com.funambol.framework.core.ItemizedCommand;
import com.funambol.framework.core.Meta;
import com.funambol.framework.core.SessionID;
import com.funambol.framework.core.Source;
import com.funambol.framework.core.Target;
import com.funambol.framework.core.VerDTD;
import com.funambol.framework.core.VerProto;
import com.funambol.framework.protocol.ProtocolException;
import com.funambol.framework.protocol.v11.Errors;

public class BasicRequirements
implements Errors {
    public static final VerDTD[] SUPPORTED_DTD_VERSIONS = new VerDTD[]{Constants.DTD_1_0, Constants.DTD_1_1, Constants.DTD_1_2};
    public static final VerProto[] SUPPORTED_PROTOCOL_VERSIONS = new VerProto[]{Constants.SYNCML_DS_1_0, Constants.SYNCML_DS_1_1, Constants.SYNCML_DS_1_1_1, Constants.SYNCML_DM_1_1, Constants.SYNCML_DM_1_2};
    public static final String CAPABILITIES_SOURCE = "./devinf11";
    public static final String CAPABILITIES_TARGET = "./devinf11";
    public static final String SERVER_CAPABILITIES = "server";
    public static final String CLIENT_CAPABILITIES = "client";

    public static void checkDTDVersion(VerDTD version) throws ProtocolException {
        for (int i = 0; i < SUPPORTED_DTD_VERSIONS.length; ++i) {
            if (!SUPPORTED_DTD_VERSIONS[i].equals(version)) continue;
            return;
        }
        Object[] args = new String[]{version.toString()};
        throw new ProtocolException("DTD ver {0} not supported", args);
    }

    public static void checkProtocolVersion(VerProto version) throws ProtocolException {
        for (int i = 0; i < SUPPORTED_PROTOCOL_VERSIONS.length; ++i) {
            if (!SUPPORTED_PROTOCOL_VERSIONS[i].equals(version)) continue;
            return;
        }
        Object[] args = new String[]{version.toString()};
        throw new ProtocolException("Protocol ver {0} not supported", args);
    }

    public static void checkSessionId(SessionID id) throws ProtocolException {
        if (id == null || id.toString().trim().length() == 0) {
            throw new ProtocolException("Missing session ID");
        }
    }

    public static void checkMessageId(String id) throws ProtocolException {
        if (id == null || id.trim().length() == 0) {
            throw new ProtocolException("Missing message ID");
        }
    }

    public static void checkTarget(Target target) throws ProtocolException {
        boolean valid = target != null;
        boolean location = false;
        boolean uri = false;
        if (valid) {
            location = target.getLocName() != null && target.getLocName().trim().length() != 0;
            uri = target.getLocURI() != null;
            boolean bl = valid = location || uri;
        }
        if (!valid) {
            Object[] args = new String[]{target == null ? "null" : target.getLocURI()};
            throw new ProtocolException("Invalid target ({0})", args);
        }
    }

    public static void checkSource(Source source) throws ProtocolException {
        boolean valid = source != null;
        boolean location = false;
        boolean uri = false;
        if (valid) {
            location = source.getLocName() != null && source.getLocName().trim().length() != 0;
            uri = source.getLocURI() != null;
            boolean bl = valid = location || uri;
        }
        if (!valid) {
            Object[] args = new String[]{source == null ? "null" : source.getLocURI()};
            throw new ProtocolException("Invalid source({0})", args);
        }
    }

    public static void checkCommandId(CmdID commandId) throws ProtocolException {
        String cmdValue = null;
        if (commandId == null || (cmdValue = commandId.getCmdID()) == null || cmdValue.trim().length() == 0) {
            throw new ProtocolException("Missing message ID");
        }
    }

    public static void checkAlertCommand(Alert alert) throws ProtocolException {
        Object[] args = new String[]{"alert is null!"};
        if (alert == null) {
            throw new ProtocolException("Invalid alert command ({0})", args);
        }
        try {
            BasicRequirements.checkCommandId(alert.getCmdID());
        }
        catch (ProtocolException e) {
            args = new String[]{e.getMessage()};
            throw new ProtocolException("Invalid alert command ({0})", args);
        }
    }

    public static void checkCapabilities(ItemizedCommand cmd, String device) throws ProtocolException {
        try {
            BasicRequirements.checkCommandId(cmd.getCmdID());
        }
        catch (ProtocolException e) {
            Object[] args = new String[]{device, e.getMessage()};
            throw new ProtocolException("Invalid {0} capabilities ({1})", args);
        }
        Meta meta = cmd.getMeta();
        if (meta == null) {
            Object[] args = new Object[]{device, "missing metadata"};
            throw new ProtocolException("Invalid {0} capabilities ({1})", args);
        }
        if (meta.getType() == null) {
            Object[] args = new Object[]{device, "invalid metadata type"};
            throw new ProtocolException("Invalid {0} capabilities ({1})", args);
        }
        Item[] items = cmd.getItems().toArray(new Item[0]);
        if (items == null || items.length == 0) {
            Object[] args = new String[]{device, "The item element is missing"};
            throw new ProtocolException("Invalid {0} capabilities ({1})", args);
        }
        try {
            BasicRequirements.checkSource(items[0].getSource());
        }
        catch (ProtocolException e) {
            Object[] args = new String[]{device, "missing source"};
            throw new ProtocolException("Invalid {0} capabilities ({1})", args);
        }
        if (!"./devinf11".equals(items[0].getSource().getLocURI().toString())) {
            Object[] args = new String[]{device, "URI not ./devinf11"};
            throw new ProtocolException("Invalid {0} capabilities ({1})", args);
        }
    }
}

