/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.transport.http;

import com.funambol.framework.transport.http.SyncHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SyncHolderCache {
    public static final long CLEANING_PERIOD = 300000L;
    public static final long DEFAULT_TTL = 300000L;
    public static final String LOG_NAME = "funambol.transport.http";
    private static final Logger log = Logger.getLogger((String)SyncHolderCache.class.getName());
    private long holderTimeToLive = 300000L;
    private long lastCleaningTimestamp = 0L;
    private Map<Object, SyncHolder> cache = new HashMap<Object, SyncHolder>(97);

    public SyncHolderCache(long timeToLive) {
        this.lastCleaningTimestamp = System.currentTimeMillis();
        this.holderTimeToLive = timeToLive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(SyncHolder holder) {
        this.clean();
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("Caching " + holder.getSessionId() + '(' + holder + ')'));
        }
        Map<Object, SyncHolder> map = this.cache;
        synchronized (map) {
            this.cache.put(holder.getSessionId(), holder);
        }
    }

    public SyncHolder get(String sessionId) {
        return this.cache.get(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String sessionId) {
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("Removing holder for " + sessionId));
        }
        Map<Object, SyncHolder> map = this.cache;
        synchronized (map) {
            this.cache.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String s = null;
        Map<Object, SyncHolder> map = this.cache;
        synchronized (map) {
            s = String.valueOf(this.cache);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clean() {
        long now = System.currentTimeMillis();
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)"Cleaning procedure...");
            log.trace((Object)("now: " + now));
            log.trace((Object)"CLEANING_PERIOD: 300000");
            log.trace((Object)("lastCleaningTimestamp: " + this.lastCleaningTimestamp));
            log.trace((Object)("holderTimeToLive: " + this.holderTimeToLive));
        }
        ArrayList<Object> toBeRemoved = null;
        Iterator<Object> i = null;
        Map<Object, SyncHolder> map = this.cache;
        synchronized (map) {
            if (now - this.lastCleaningTimestamp <= 300000L) {
                if (log.isEnabledFor((Priority)Level.TRACE)) {
                    log.trace((Object)"No purging required");
                }
                return false;
            }
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.trace((Object)"Performing purging...");
            }
            toBeRemoved = new ArrayList<Object>();
            for (Object key : this.cache.keySet()) {
                SyncHolder value = this.cache.get(key);
                if (!(value instanceof SyncHolder)) {
                    if (log.isEnabledFor((Priority)Level.TRACE)) {
                        log.trace((Object)("Found unexpected object: " + key + " will be removed!"));
                    }
                    toBeRemoved.add(key);
                    continue;
                }
                SyncHolder h = value;
                if (now - h.getCreationTimestamp() <= this.holderTimeToLive) continue;
                if (log.isEnabledFor((Priority)Level.TRACE)) {
                    log.trace((Object)("Purging holder for session " + key));
                }
                try {
                    h.close();
                }
                catch (Exception e) {
                    log.fatal((Object)e.getMessage());
                    log.debug((Object)"clean", (Throwable)e);
                }
                toBeRemoved.add(key);
            }
            i = toBeRemoved.iterator();
            while (i.hasNext()) {
                this.cache.remove(i.next());
            }
        }
        this.lastCleaningTimestamp = System.currentTimeMillis();
        return true;
    }
}

