/*
 * Decompiled with CFR 0.152.
 */
package org.vmguys.vmtools.utils;

import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.vmguys.vmtools.utils.AbstractOperation;
import org.vmguys.vmtools.utils.DiffElement;

public class ElementRenameOperation
extends AbstractOperation {
    private String newName;

    public ElementRenameOperation(DiffElement node, String newName) {
        this(node, newName, null);
    }

    public ElementRenameOperation(DiffElement node, String newName, String comment) {
        this.node = node;
        this.newName = newName;
        this.comment = comment;
    }

    public Element asElement(Namespace namespace) {
        Element el = new Element("ElementName", namespace);
        el.setAttribute("Operation", "modify");
        el.setAttribute("Value", this.newName);
        if (this.comment != null) {
            Comment c = new Comment(this.comment);
            el.addContent(c);
        }
        return el;
    }

    public int cost() {
        return 1;
    }

    public String toString() {
        String cmt = this.comment == null ? "" : " (" + this.comment + ")";
        return "modify the name from " + this.node.getName() + " to " + this.newName + cmt;
    }

    public String getOperationXpath() throws JDOMException {
        return this.node.getXpath();
    }

    public int getOperationNodeNumber() {
        return this.node.getNodeNumber();
    }
}

