/*
 * Decompiled with CFR 0.152.
 */
package org.vmguys.vmtools.utils;

import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.vmguys.vmtools.utils.XPath;

public class JdomPatcher {
    private Namespace namespace;
    private boolean discardWhitespace;

    public JdomPatcher() {
        this(Namespace.NO_NAMESPACE);
    }

    public JdomPatcher(Namespace namespace) {
        this(namespace, true);
    }

    public JdomPatcher(Namespace namespace, boolean discardWhitespace) {
        this(namespace, discardWhitespace, false);
    }

    public JdomPatcher(Namespace namespace, boolean discardWhitespace, boolean addComments) {
        this.discardWhitespace = discardWhitespace;
        this.namespace = namespace;
    }

    public Element patch(Element originalTree, Element patchTree) throws JDOMException {
        return this.patch(originalTree, patchTree.getChildren());
    }

    public Element patch(Element originalTree, List patchList) throws JDOMException {
        int i;
        Element rslt = (Element)originalTree.clone();
        if (this.discardWhitespace) {
            this.discardWhitespace(rslt);
            i = 0;
            while (i < patchList.size()) {
                this.discardWhitespace((Element)patchList.get(i));
                ++i;
            }
        }
        i = 0;
        while (i < patchList.size()) {
            Element child = (Element)patchList.get(i);
            if (!child.getName().equals("Position")) {
                throw new JDOMException("expecting \"Position\"; found \"" + child.getName() + "\"");
            }
            rslt = this.processPosition(rslt, child);
            ++i;
        }
        return rslt;
    }

    /*
     * Unable to fully structure code
     */
    private Element processPosition(Element tree, Element position) throws JDOMException {
        rslt = null;
        xpath = position.getAttributeValue("XPath");
        if (xpath == null) {
            throw new JDOMException("Position element has no XPath attribute");
        }
        currNode = XPath.getElement(tree, xpath);
        if (currNode == null) {
            throw new JDOMException("there is no element for xpath \"" + xpath + "\"");
        }
        currElement = null;
        if (currNode instanceof Element) {
            currElement = (Element)currNode;
        }
        opOrder = new String[]{"Subtree", "Attribute", "Element"};
        curOp = 0;
        operands = position.getChildren();
        i = 0;
        while (i < operands.size()) {
            block11: {
                operand = (Element)operands.get(i);
                if (i != 0 || operands.size() != 1 || !operand.getName().equals("Root")) ** GOTO lbl21
                rslt = this.processRoot(tree, currElement, operand);
                break block11;
lbl-1000:
                // 1 sources

                {
                    ++curOp;
lbl21:
                    // 2 sources

                    ** while (curOp < opOrder.length - 1 && !operand.getName().equals((Object)opOrder[curOp]))
                }
lbl22:
                // 1 sources

                if (!operand.getName().equals(opOrder[curOp])) {
                    throw new JDOMException("expecting operand type \"" + opOrder[curOp] + "\"; found \"" + operand.getName() + "\"");
                }
                switch (curOp) {
                    case 0: {
                        rslt = this.processSubtree(tree, currElement, operand);
                        break;
                    }
                    case 1: {
                        rslt = this.processAttribute(tree, currElement, operand);
                        break;
                    }
                    case 2: {
                        rslt = this.processElement(tree, currNode, operand, xpath);
                        break;
                    }
                    default: {
                        throw new Error("internal error in processPosition; curOp=" + curOp);
                    }
                }
            }
            ++i;
        }
        return rslt;
    }

    private Element processRoot(Element tree, Element currElement, Element rootRequest) throws JDOMException {
        Element rslt = null;
        String operation = rootRequest.getAttributeValue("Operation");
        if (operation.equals("replace")) {
            String elementName = currElement.getName();
            Element replacement = (Element)rootRequest.getChild(elementName).clone();
            if (replacement == null) {
                throw new JDOMException("expected replacement element to have name \"" + elementName + "\"");
            }
            Element parent = currElement.getParent();
            if (parent != null) {
                rslt = tree;
                List siblings = parent.getChildren();
                int i = siblings.indexOf(currElement);
                siblings.remove(i);
                siblings.add(i, replacement);
            } else {
                rslt = replacement;
            }
        } else {
            throw new JDOMException("Root operation should be \"replace\"; found \"" + operation + "\"");
        }
        return rslt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Element processSubtree(Element tree, Element currElement, Element subtreeRequest) throws JDOMException {
        String operation = subtreeRequest.getAttributeValue("Operation");
        if (operation.equals("insert")) {
            int childNum = -1;
            String childNumAttr = subtreeRequest.getAttributeValue("Child");
            if (childNumAttr != null && (childNum = Integer.parseInt(childNumAttr) - 1) < 0) {
                throw new JDOMException("Subtree insert request has invalid child number (" + (childNum + 1) + ")");
            }
            Element newSubtree = (Element)((Element)subtreeRequest.getChildren().get(0)).clone();
            List children = currElement.getChildren();
            if (childNum < 0 || childNum >= children.size()) {
                children.add(newSubtree);
                return tree;
            } else {
                children.add(childNum, newSubtree);
            }
            return tree;
        } else {
            if (!operation.equals("delete")) throw new JDOMException("Subtree operation should be \"insert\" or \"delete\"; found \"" + operation + "\"");
            Element parent = currElement.getParent();
            if (parent == null) throw new JDOMException("Subtree delete request cannot delete root element \"" + currElement.getName() + "\"");
            List siblings = parent.getChildren();
            siblings.remove(currElement);
        }
        return tree;
    }

    private Element processAttribute(Element tree, Element currElement, Element attrRequest) throws JDOMException {
        String operation = attrRequest.getAttributeValue("Operation");
        String attrName = attrRequest.getAttributeValue("Name");
        if (attrName == null) {
            throw new JDOMException("Attribute " + operation + " request contains null attribute name");
        }
        if (operation.equals("insert") || operation.equals("modify")) {
            String attrValue = attrRequest.getAttributeValue("Value");
            currElement.setAttribute(attrName, attrValue);
        } else if (operation.equals("delete")) {
            currElement.removeAttribute(attrName);
        } else {
            throw new JDOMException("Attribute operation should be \"insert\", \"modify\" or \"delete\"; found \"" + operation + "\"");
        }
        return tree;
    }

    private Element processElement(Element tree, Object currElement, Element elementRequest, String xpath) throws JDOMException {
        String operation = elementRequest.getAttributeValue("Operation");
        if (operation.equals("insert")) {
            int childNum = -1;
            String childNumAttr = elementRequest.getAttributeValue("Child");
            if (childNumAttr != null && (childNum = Integer.parseInt(childNumAttr) - 1) < 0) {
                throw new JDOMException("Element insert request has invalid child number (" + (childNum + 1) + ")");
            }
            Object newObject = elementRequest.getContent().get(0);
            if (newObject instanceof Element) {
                this.insertElement((Element)currElement, (Element)newObject, childNum);
            } else {
                Element parent = XPath.getParentElement(tree, xpath);
                this.insertContent(parent, newObject, childNum);
            }
        } else if (operation.equals("modify")) {
            Object newObject = elementRequest.getContent().get(0);
            if (newObject instanceof Element) {
                this.modifyElement((Element)currElement, (Element)newObject);
            } else {
                Element parent = XPath.getParentElement(tree, xpath);
                this.modifyContent(parent, newObject, xpath);
            }
        } else if (operation.equals("delete")) {
            if (currElement instanceof Element) {
                this.deleteElement((Element)currElement);
            } else {
                Element parent = XPath.getParentElement(tree, xpath);
                this.deleteContent(parent, xpath);
            }
        } else {
            throw new JDOMException("Element operation should be \"insert\", \"modify\" or \"delete\"; found \"" + operation + "\"");
        }
        return tree;
    }

    private void insertElement(Element currElement, Element newElement, int childNum) throws JDOMException {
        if (newElement.hasChildren()) {
            throw new JDOMException("Element insert request cannot be used to insert a subtree; element \"" + newElement.getName() + "\" has children");
        }
        this.insertContent(currElement, (Element)newElement.clone(), childNum);
    }

    private void insertContent(Element parent, Object newContent, int childNum) throws JDOMException {
        List children = parent.getChildren();
        if (childNum < 0 || childNum >= children.size()) {
            children.add(newContent);
        } else {
            children.add(childNum, newContent);
        }
        boolean a = false;
    }

    private void modifyElement(Element currElement, Element newElement) throws JDOMException {
        List content;
        String elementName = currElement.getName();
        if (newElement.getName().equals(currElement.getName())) {
            content = currElement.getContent();
            int i = content.size() - 1;
            while (i >= 0) {
                Object x = content.get(i);
                if (x instanceof String) {
                    content.remove(i);
                }
                --i;
            }
        } else {
            throw new JDOMException("Element modify request must contain element with same name as existing element \"" + currElement.getName() + "\"");
        }
        content.addAll(newElement.getContent());
    }

    private void modifyContent(Element parent, Object newContent, String xpath) throws JDOMException {
        int childNum = XPath.getIndex(xpath);
        List content = parent.getContent();
        content.set(childNum, newContent);
    }

    private void deleteElement(Element currElement) throws JDOMException {
        Element parent = currElement.getParent();
        if (parent == null) {
            throw new JDOMException("Element delete request cannot delete root node of tree (" + currElement.getName() + ")");
        }
        List siblings = parent.getChildren();
        int childNum = siblings.indexOf(currElement);
        List children = currElement.getChildren();
        siblings.remove(childNum);
        siblings.addAll(childNum, children);
    }

    private void deleteContent(Element parent, String xpath) throws JDOMException {
        int childNum = XPath.getIndex(xpath);
        List content = parent.getContent();
        content.remove(childNum);
    }

    public boolean isDiscardWhitespace() {
        return this.discardWhitespace;
    }

    public void setDiscardWhitespace(boolean discardWhitespace) {
        this.discardWhitespace = discardWhitespace;
    }

    private void discardWhitespace(Element node) {
        List contents = node.getContent();
        int i = contents.size() - 1;
        while (i >= 0) {
            Object x = contents.get(i);
            if (x instanceof String) {
                String s = ((String)x).trim();
                if (s.length() < ((String)x).length()) {
                    contents.remove(i);
                    if (s.length() > 0) {
                        contents.add(i, s);
                    }
                }
            } else if (x instanceof Element) {
                this.discardWhitespace((Element)x);
            }
            --i;
        }
    }
}

