/*
 * Decompiled with CFR 0.152.
 */
package org.vmguys.vmtools.utils;

import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.vmguys.vmtools.utils.AttributeDeleteOperation;
import org.vmguys.vmtools.utils.AttributeInsertOperation;
import org.vmguys.vmtools.utils.AttributeModifyOperation;
import org.vmguys.vmtools.utils.ContentAddOperation;
import org.vmguys.vmtools.utils.ContentDeleteOperation;
import org.vmguys.vmtools.utils.ContentModifyOperation;
import org.vmguys.vmtools.utils.CostOps;
import org.vmguys.vmtools.utils.DiffElement;
import org.vmguys.vmtools.utils.ElementDeleteOperation;
import org.vmguys.vmtools.utils.ElementRenameOperation;
import org.vmguys.vmtools.utils.ProgressReporter;
import org.vmguys.vmtools.utils.SubtreeDeleteOperation;
import org.vmguys.vmtools.utils.SubtreeInsertOperation;

public class DifferenceFinder2 {
    private static final boolean DEBUG = false;
    private boolean addComments;
    private boolean allowRename = true;
    private boolean discardWhitespace;
    private Namespace namespace = Namespace.NO_NAMESPACE;
    private ProgressReporter progressReporter;

    public DifferenceFinder2() {
        this(Namespace.NO_NAMESPACE, true, false);
    }

    public DifferenceFinder2(Namespace namespace) {
        this(namespace, true, false);
    }

    public DifferenceFinder2(Namespace namespace, boolean discardWhitespace) {
        this(namespace, discardWhitespace, false);
    }

    public DifferenceFinder2(Namespace namespace, boolean discardWhitespace, boolean addComments) {
        this.namespace = namespace;
        this.discardWhitespace = discardWhitespace;
        this.addComments = addComments;
        this.addComments = true;
    }

    public CostOps findDifferences(Element root1, Element root2) throws JDOMException {
        try {
            return this.findDifferences((DiffElement)root1, (DiffElement)root2);
        }
        catch (ClassCastException e) {
            throw new JDOMException("can't cast argument to DiffElement", (Throwable)e);
        }
    }

    public CostOps findDifferences(DiffElement root1, DiffElement root2) throws JDOMException {
        if (this.discardWhitespace) {
            this.discardWhitespace(root1);
            this.discardWhitespace(root2);
        }
        DiffElement[] tree1 = this.getNodesAsArray(root1);
        DiffElement[] tree2 = this.getNodesAsArray(root2);
        CostOps[][] d = new CostOps[tree1.length][tree2.length];
        int solvedEntries = 0;
        int totalEntries = tree1.length * tree2.length;
        int i1 = 1;
        while (i1 < tree1.length) {
            if (tree1[i1].hasLeftSibling() || tree1[i1] == root1) {
                DiffElement x = tree1[i1];
                int xLeftLeafNum = x.getLeftmostLeafNum();
                int i2 = 1;
                while (i2 < tree2.length) {
                    if (tree2[i2].hasLeftSibling() || tree2[i2] == root2) {
                        DiffElement y = tree2[i2];
                        int yLeftLeafNum = y.getLeftmostLeafNum();
                        CostOps[][] fd = new CostOps[x.getNodeNumber() + 1][y.getNodeNumber() + 1];
                        fd[xLeftLeafNum - 1][yLeftLeafNum - 1] = new CostOps();
                        int i = xLeftLeafNum;
                        while (i <= x.getNodeNumber()) {
                            fd[i][yLeftLeafNum - 1] = fd[tree1[i].getLeftmostLeafNum() - 1][yLeftLeafNum - 1].combine(this.deleteSubtree(tree1[i]));
                            ++i;
                        }
                        int j = yLeftLeafNum;
                        while (j <= y.getNodeNumber()) {
                            fd[xLeftLeafNum - 1][j] = fd[xLeftLeafNum - 1][tree2[j].getLeftmostLeafNum() - 1].combine(this.insertSubtree(tree2[j]));
                            ++j;
                        }
                        int i3 = xLeftLeafNum;
                        while (i3 <= x.getNodeNumber()) {
                            int j2 = yLeftLeafNum;
                            while (j2 <= y.getNodeNumber()) {
                                int iLeftLeafNum = tree1[i3].getLeftmostLeafNum();
                                int jLeftLeafNum = tree2[j2].getLeftmostLeafNum();
                                CostOps deleteCost = fd[i3 - 1][j2].combine(this.deleteNode(tree1[i3]));
                                CostOps deleteSubtreeCost = fd[iLeftLeafNum - 1][j2].combine(this.deleteSubtree(tree1[i3]));
                                CostOps insertSubtreeCost = fd[i3][jLeftLeafNum - 1].combine(this.insertSubtree(tree2[j2]));
                                CostOps m = this.min(deleteCost, deleteSubtreeCost, insertSubtreeCost);
                                if (iLeftLeafNum == xLeftLeafNum && jLeftLeafNum == yLeftLeafNum) {
                                    fd[i3][j2] = this.min(m, fd[i3 - 1][j2 - 1].combine(this.editNode(tree1[i3], tree2[j2])));
                                    d[i3][j2] = fd[i3][j2];
                                    ++solvedEntries;
                                } else {
                                    fd[i3][j2] = this.min(m, fd[iLeftLeafNum - 1][jLeftLeafNum - 1].combine(d[i3][j2]));
                                }
                                ++j2;
                            }
                            ++i3;
                        }
                    }
                    if (this.progressReporter != null) {
                        this.progressReporter.showProgress(solvedEntries, totalEntries);
                    }
                    ++i2;
                }
            }
            ++i1;
        }
        if (this.progressReporter != null) {
            this.progressReporter.showProgress(totalEntries, totalEntries);
        }
        CostOps s = d[tree1.length - 1][tree2.length - 1];
        return s;
    }

    private DiffElement[] getNodesAsArray(DiffElement root) {
        DiffElement[] a = new DiffElement[root.getNodeNumber() + 1];
        a[root.getNodeNumber()] = root;
        this.getNodesAsArray2(a, root);
        return a;
    }

    private void getNodesAsArray2(DiffElement[] a, DiffElement n) {
        List children = n.getChildren();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            DiffElement child;
            a[child.getNodeNumber()] = child = (DiffElement)((Object)it.next());
            this.getNodesAsArray2(a, child);
        }
    }

    private CostOps deleteNode(DiffElement n) {
        return new CostOps(new ElementDeleteOperation(n));
    }

    private CostOps deleteSubtree(DiffElement n) {
        return new CostOps(new SubtreeDeleteOperation(n));
    }

    private CostOps insertSubtree(DiffElement n) {
        return new CostOps(new SubtreeInsertOperation(n));
    }

    private CostOps editNode(DiffElement n1, DiffElement n2) {
        CostOps rslt = new CostOps();
        if (!n1.getName().equals(n2.getName())) {
            if (this.allowRename) {
                rslt.add(new ElementRenameOperation(n1, n2.getName()));
            } else {
                rslt.add(10000);
            }
        }
        this.editContents(n1, n2, rslt);
        this.editAttributes(n1, n2, rslt);
        return rslt;
    }

    private void editContents(DiffElement n1, DiffElement n2, CostOps rslt) {
        Object[] content1 = n1.getContentAsArray();
        Object[] content2 = n2.getContentAsArray();
        if (content1.length == 1 && content2.length == 1) {
            if (!content1[0].equals(content2[0])) {
                rslt.add(new ContentModifyOperation(n1, content1[0], content2[0]));
            }
        } else {
            int i1 = 0;
            int i2 = 0;
            while (i1 < content1.length && i2 < content2.length) {
                if (content1[i1].equals(content2[i2])) {
                    ++i1;
                    ++i2;
                    continue;
                }
                rslt.add(new ContentDeleteOperation(n1, content1[i1]));
                ++i1;
            }
            while (i1 < content1.length) {
                rslt.add(new ContentDeleteOperation(n1, content1[i1]));
                ++i1;
            }
            while (i2 < content2.length) {
                rslt.add(new ContentAddOperation(n2, content2[i2]));
                ++i2;
            }
        }
    }

    private void editAttributes(DiffElement n1, DiffElement n2, CostOps rslt) {
        Attribute[] attr1 = n1.getAttributesAsArray();
        Attribute[] attr2 = n2.getAttributesAsArray();
        int i1 = 0;
        int i2 = 0;
        while (i1 < attr1.length && i2 < attr2.length) {
            int nameCompare = attr1[i1].getName().compareTo(attr2[i2].getName());
            if (nameCompare == 0) {
                if (!attr1[i1].getValue().equals(attr2[i2].getValue())) {
                    rslt.add(new AttributeModifyOperation(n1, attr2[i2], null));
                }
                ++i1;
                ++i2;
                continue;
            }
            if (nameCompare < 0) {
                rslt.add(new AttributeDeleteOperation(n1, attr1[i1]));
                ++i1;
                continue;
            }
            rslt.add(new AttributeInsertOperation(n1, attr2[i2], null));
            ++i2;
        }
        while (i1 < attr1.length) {
            rslt.add(new AttributeDeleteOperation(n1, attr1[i1]));
            ++i1;
        }
        while (i2 < attr2.length) {
            rslt.add(new AttributeInsertOperation(n1, attr2[i2], null));
            ++i2;
        }
    }

    private int min(int a, int b) {
        return a < b ? a : b;
    }

    private int min(int a, int b, int c, int d) {
        return this.min(this.min(a, b), this.min(c, d));
    }

    private CostOps min(CostOps a, CostOps b) {
        return a.getCost() <= b.getCost() ? a : b;
    }

    private CostOps min(CostOps a, CostOps b, CostOps c) {
        return this.min(this.min(a, b), c);
    }

    private CostOps min(CostOps a, CostOps b, CostOps c, CostOps d) {
        return this.min(this.min(a, b), this.min(c, d));
    }

    private void discardWhitespace(Element node) {
        List contents = node.getContent();
        int i = contents.size() - 1;
        while (i >= 0) {
            Object x = contents.get(i);
            if (x instanceof String) {
                String s = ((String)x).trim();
                if (s.length() < ((String)x).length()) {
                    contents.remove(i);
                    if (s.length() > 0) {
                        contents.add(i, s);
                    }
                }
            } else if (x instanceof Element) {
                this.discardWhitespace((Element)x);
            }
            --i;
        }
    }

    public boolean isDiscardWhitespace() {
        return this.discardWhitespace;
    }

    public void setDiscardWhitespace(boolean discardWhitespace) {
        this.discardWhitespace = discardWhitespace;
    }

    public boolean isAddComments() {
        return this.addComments;
    }

    public void setAddComments(boolean addComments) {
        this.addComments = addComments;
    }

    public ProgressReporter getProgressReporter() {
        return this.progressReporter;
    }

    public void setProgressReporter(ProgressReporter progressReporter) {
        this.progressReporter = progressReporter;
    }

    public boolean isAllowRename() {
        return this.allowRename;
    }

    public void setAllowRename(boolean allowRename) {
        this.allowRename = allowRename;
    }
}

