/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.server;

import com.funambol.framework.security.Sync4jPrincipal;
import com.funambol.framework.server.error.MappingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ClientMapping {
    private HashMap<String, String> clientMapping = new HashMap();
    private Sync4jPrincipal principal = null;
    private String dbURI;
    private boolean modified = false;
    private ArrayList<String> modifiedKeys = new ArrayList();
    private boolean deleted = false;
    private ArrayList<String> deletedKeys = new ArrayList();
    private static final transient Logger log = Logger.getLogger((String)ClientMapping.class.getName());

    public ClientMapping(Sync4jPrincipal principal, String dbURI) {
        this.principal = principal;
        this.dbURI = dbURI;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void initializeFromMapping(Map<String, String> mapping) {
        this.resetMapping();
        this.clientMapping.putAll(mapping);
    }

    public Map<String, String> getDeletedEntries() {
        HashMap<String, String> result = null;
        if (this.deleted) {
            result = new HashMap<String, String>();
            for (int i = 0; i < this.deletedKeys.size(); ++i) {
                String item = this.deletedKeys.get(i);
                result.put(item, this.clientMapping.get(item));
            }
        }
        return result;
    }

    public Map<String, String> getModifiedEntries() {
        HashMap<String, String> result = null;
        if (this.modified) {
            result = new HashMap<String, String>();
            for (int i = 0; i < this.modifiedKeys.size(); ++i) {
                String item = this.modifiedKeys.get(i);
                result.put(item, this.clientMapping.get(item));
            }
        }
        return result;
    }

    public Map<String, String> getMapping() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.putAll(this.clientMapping);
        return ret;
    }

    public String getClientDeviceId() {
        return this.principal.getDeviceId();
    }

    public Sync4jPrincipal getPrincipal() {
        return this.principal;
    }

    public String getDbURI() {
        return this.dbURI;
    }

    private void addMapping(String luid, String guid) throws MappingException {
        if (this.clientMapping.containsKey(guid)) {
            throw new MappingException("Mapping already exists for GUID " + guid + " (" + luid + ")");
        }
        this.modified = true;
        this.clientMapping.put(luid, guid);
        this.modifiedKeys.add(luid);
        this.removeDeletedKey(luid);
    }

    public String getMappedValueForLuid(String luid) {
        String result = null;
        result = this.clientMapping.get(luid);
        if (result == null && log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("No mapping found for LUID: " + luid));
        }
        return result;
    }

    public String getMappedValueForGuid(String guid) {
        String result = null;
        if (this.clientMapping.containsValue(guid)) {
            Set<String> keys = this.clientMapping.keySet();
            for (String key : keys) {
                String value = this.clientMapping.get(key);
                if (!value.equalsIgnoreCase(guid)) continue;
                return key;
            }
        }
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("No mapping found for GUID: " + guid));
        }
        return result;
    }

    public void removeMappedValuesForLuid(String luid) {
        if (this.clientMapping.remove(luid) == null) {
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.trace((Object)("Client Mapping not found for LUID " + luid + " when removing"));
            }
            return;
        }
        this.addDeletedKey(luid);
    }

    public void removeMappedValuesForGuid(String guid) {
        String luid = this.getMappedValueForGuid(guid);
        if (luid == null) {
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.trace((Object)("Client Mapping not found for GUID " + guid + " when removing"));
            }
            return;
        }
        this.clientMapping.remove(luid);
        this.addDeletedKey(luid);
    }

    public void updateMapping(String luid, String guid) throws MappingException {
        if (!this.clientMapping.containsKey(guid)) {
            this.addMapping(luid, guid);
            return;
        }
        this.clientMapping.remove(guid);
        this.clientMapping.put(luid, guid);
        this.deletedKeys.remove(luid);
        this.modifiedKeys.add(luid);
        this.modified = true;
        assert (this.modified);
    }

    public void clearMappings() {
        this.deletedKeys.addAll(this.clientMapping.values());
        this.deletedKeys.addAll(this.modifiedKeys);
        this.clientMapping.clear();
        this.modified = false;
        this.deleted = true;
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder((Object)this);
        sb.append("clientMapping", this.clientMapping);
        sb.append("modifiedKeys", this.modifiedKeys);
        sb.append("deletedKeys", this.deletedKeys);
        return sb.toString();
    }

    private void resetMapping() {
        if (!this.clientMapping.isEmpty()) {
            this.clientMapping.clear();
        }
        if (this.modified) {
            this.modifiedKeys.clear();
            this.modified = false;
        }
        if (this.deleted) {
            this.deletedKeys.clear();
            this.deleted = false;
        }
    }

    private void removeDeletedKey(String luid) {
        if (this.deleted && this.deletedKeys.contains(luid)) {
            this.deletedKeys.remove(luid);
            if (this.deletedKeys.isEmpty()) {
                this.deleted = false;
            }
        }
    }

    private void removeModifiedKey(String luid) {
        if (this.modified && this.modifiedKeys.contains(luid)) {
            this.modifiedKeys.remove(luid);
            if (this.modifiedKeys.isEmpty()) {
                this.modified = false;
            }
        }
    }

    private void addDeletedKey(String luid) {
        this.removeModifiedKey(luid);
        this.deleted = true;
        this.deletedKeys.add(luid);
    }
}

