/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.protocol;

import com.funambol.framework.core.SyncBody;
import com.funambol.framework.core.SyncHdr;
import com.funambol.framework.core.SyncML;
import com.funambol.framework.core.VerDTD;
import com.funambol.framework.core.VerProto;
import com.funambol.framework.protocol.Flags;
import com.funambol.framework.protocol.ProtocolException;
import com.funambol.framework.tools.CommandIdGenerator;

public abstract class SyncPackage
implements Flags {
    protected SyncHdr syncHeader = null;
    protected SyncBody syncBody = null;
    private boolean[] flags = new boolean[11];
    protected CommandIdGenerator idGenerator = null;

    public SyncPackage(SyncHdr syncHeader, SyncBody syncBody) {
        this.syncHeader = syncHeader;
        this.syncBody = syncBody;
    }

    public void setFlagValue(int flag, boolean value) {
        switch (flag) {
            case -1: {
                for (int i = 0; i < 11; ++i) {
                    this.flags[i] = value;
                }
                break;
            }
            case -2: {
                this.flags[1] = this.flags[2] = value;
                this.flags[0] = this.flags[2];
                break;
            }
            default: {
                this.flags[flag] = value;
            }
        }
    }

    public void setFlag(int flag) {
        this.setFlagValue(flag, true);
    }

    public void unsetFlag(int flag) {
        this.setFlagValue(flag, false);
    }

    public boolean isFlag(int flag) {
        return this.flags[flag];
    }

    public CommandIdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(CommandIdGenerator idGenerator) {
        if (idGenerator == null) {
            throw new NullPointerException("idGenerator cannot be null");
        }
        this.idGenerator = idGenerator;
    }

    public String getSessionId() {
        return this.syncHeader.getSessionID().getSessionID();
    }

    public VerDTD getDTDVersion() {
        return this.syncHeader.getVerDTD();
    }

    public VerProto getProtocolVersion() {
        return this.syncHeader.getVerProto();
    }

    public void checkRequirements() throws ProtocolException {
        this.checkHeaderRequirements();
        this.checkBodyRequirements();
    }

    public SyncHdr getSyncHeader() {
        return this.syncHeader;
    }

    public SyncBody getSyncBody() {
        return this.syncBody;
    }

    public boolean isFinal() {
        return this.syncBody.isFinalMsg();
    }

    public abstract void checkHeaderRequirements() throws ProtocolException;

    public abstract void checkBodyRequirements() throws ProtocolException;

    public abstract SyncML getResponse(String var1) throws ProtocolException;
}

