/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.adapt;

import org.apache.log4j.Logger;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Message;
import org.jgroups.TimeoutException;

public class ReceiverThread
extends Thread {
    private Channel channel;
    private long msgs_burst;
    private long num_bursts;
    private int msg_size;
    private int num_senders;
    Logger log = Logger.getLogger(this.getClass());
    long counter = 1L;
    long expected_msgs = this.msgs_burst * this.num_bursts * (long)this.num_senders;
    long beginning = 0L;
    long ending = 0L;
    long elapsed_time;
    long last_dump;
    long log_interval = 1000L;
    boolean gnuplot_output = Boolean.getBoolean("gnuplot_output");

    public ReceiverThread(Channel ch, long mb, int nb, int ms, int ns, long log_interval) {
        this.channel = ch;
        this.msgs_burst = mb;
        this.num_bursts = nb;
        this.msg_size = ms;
        this.num_senders = ns;
        this.expected_msgs = this.msgs_burst * this.num_bursts * (long)this.num_senders;
        this.log_interval = log_interval;
    }

    public void run() {
        System.out.println("\nReceiver thread started...\n");
        this.counter = 1L;
        this.beginning = 0L;
        this.ending = 0L;
        if (this.gnuplot_output) {
            StringBuffer sb = new StringBuffer();
            sb.append("\n##### msgs_received");
            sb.append(", free_mem [KB] ");
            sb.append(", total_mem [KB] ");
            sb.append(", total_msgs_sec [msgs/sec] ");
            sb.append(", total_throughput [KB/sec] ");
            sb.append(", rolling_msgs_sec (last ").append(this.log_interval).append(" msgs) ");
            sb.append(" [msgs/sec] ");
            sb.append(", rolling_throughput (last ").append(this.log_interval).append(" msgs) ");
            sb.append(" [KB/sec]\n");
            this.log.info((Object)sb.toString());
        }
        while (this.counter <= this.expected_msgs) {
            try {
                Object received = this.channel.receive(60000L);
                if (!(received instanceof Message)) continue;
                if (this.counter == 1L) {
                    this.last_dump = this.beginning = System.currentTimeMillis();
                }
                if (this.counter == this.expected_msgs) {
                    this.ending = System.currentTimeMillis();
                }
                ++this.counter;
                if (this.counter % 100L == 0L) {
                    System.out.println("-- received " + this.counter + " msgs");
                }
                if (this.counter % this.log_interval != 0L) continue;
                this.log.info((Object)this.dumpStats(this.counter));
            }
            catch (ClassCastException e) {
            }
            catch (ChannelNotConnectedException e) {
                e.printStackTrace();
            }
            catch (ChannelClosedException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                this.ending = System.currentTimeMillis();
                System.out.println("Received " + this.counter + " / " + this.expected_msgs + " messages");
                this.expected_msgs = this.counter;
                break;
            }
        }
        this.elapsed_time = this.ending - this.beginning;
        System.out.println("expected_msgs=" + this.expected_msgs + ", elapsed_time=" + this.elapsed_time);
        double throughput_s = (double)this.expected_msgs / ((double)this.elapsed_time / 1000.0);
        double throughput_b = (double)this.expected_msgs * ((double)this.msg_size / 1000.0) / ((double)this.elapsed_time / 1000.0);
        String result = "Received " + this.expected_msgs + " msgs. in " + this.elapsed_time + " msec.\n" + "Throughput: " + throughput_s + " [msgs/sec]\n" + "Throughput: " + throughput_b + " [KB/sec]\n" + "Total received: " + (double)this.expected_msgs * ((double)this.msg_size / 1000.0 / 1000.0) + " [MB]\n";
        System.out.println(result);
        this.log.info((Object)result);
        long sleep_time = 10000L;
        System.out.println("-- sleeping for " + sleep_time / 1000L + " seconds to allow for retransmissions");
        try {
            Thread.sleep(sleep_time);
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.channel.close();
        System.exit(0);
    }

    String dumpStats(long received_msgs) {
        StringBuffer sb = new StringBuffer();
        if (this.gnuplot_output) {
            sb.append(received_msgs).append(" ");
        } else {
            sb.append("\nmsgs_received=").append(received_msgs);
        }
        if (this.gnuplot_output) {
            sb.append((double)Runtime.getRuntime().freeMemory() / 1000.0).append(" ");
        } else {
            sb.append(", free_mem=").append((double)Runtime.getRuntime().freeMemory() / 1000.0);
        }
        if (this.gnuplot_output) {
            sb.append((double)Runtime.getRuntime().totalMemory() / 1000.0).append(" ");
        } else {
            sb.append(", total_mem=").append((double)Runtime.getRuntime().totalMemory() / 1000.0).append("\n");
        }
        this.dumpThroughput(sb, received_msgs);
        return sb.toString();
    }

    void dumpThroughput(StringBuffer sb, long received_msgs) {
        long current = System.currentTimeMillis();
        double tmp = 1000L * this.counter / (current - this.beginning);
        if (this.gnuplot_output) {
            sb.append(tmp).append(" ");
        } else {
            sb.append("total_msgs_sec=").append(tmp).append(" [msgs/sec]");
        }
        tmp = received_msgs * (long)this.msg_size / (current - this.beginning);
        if (this.gnuplot_output) {
            sb.append(tmp).append(" ");
        } else {
            sb.append("\ntotal_throughput=").append(tmp).append(" [KB/sec]");
        }
        tmp = 1000L * this.log_interval / (current - this.last_dump);
        if (this.gnuplot_output) {
            sb.append(tmp).append(" ");
        } else {
            sb.append("\nrolling_msgs_sec (last ").append(this.log_interval).append(" msgs)=");
            sb.append(tmp).append(" [msgs/sec]");
        }
        tmp = this.log_interval * (long)this.msg_size / (current - this.last_dump);
        if (this.gnuplot_output) {
            sb.append(tmp).append(" ");
        } else {
            sb.append("\nrolling_throughput (last ").append(this.log_interval).append(" msgs)=");
            sb.append(tmp).append(" [KB/sec]\n");
        }
        this.last_dump = current;
    }
}

