/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.commons.web.servlet;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BeanShellServlet
extends HttpServlet {
    public static final String LOG_NAME = "com.funambol.web";
    public static final String BSH_PREFIX = "WEB-INF/bsh";
    private static final Logger log = Logger.getLogger("com.funambol.web");

    public void init() throws ServletException {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doWork(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doWork(request, response);
    }

    private void doWork(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Serving " + request.getRequestURI());
        try {
            Interpreter interpreter = this.createInterpreter(request, response);
            interpreter.eval(this.getScript(request));
            Object nextView = interpreter.get("nextView");
            if (nextView != null && nextView instanceof String) {
                log.info("Forwarding to " + nextView);
                request.getRequestDispatcher((String)nextView).forward((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (Exception e) {
            this.handleError(request, response, e);
        }
    }

    private Interpreter createInterpreter(HttpServletRequest request, HttpServletResponse response) throws EvalError, IOException {
        Interpreter interpreter = new Interpreter();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            interpreter.set(key, (Object)request.getParameter(key));
        }
        interpreter.set("request", (Object)request);
        interpreter.set("response", (Object)response);
        interpreter.set("session", (Object)request.getSession(false));
        interpreter.set("out", (Object)response.getWriter());
        interpreter.eval("importCommands(\"commands\");");
        return interpreter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getScript(HttpServletRequest request) throws IOException {
        String string;
        ByteArrayOutputStream baos;
        block6: {
            String script = request.getServletPath();
            log.info(BSH_PREFIX + script);
            baos = new ByteArrayOutputStream();
            InputStream is = null;
            try {
                is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(BSH_PREFIX + script);
                if (is == null) {
                    throw new FileNotFoundException(script);
                }
                byte[] buf = new byte[1024];
                int n = 0;
                while ((n = is.read(buf)) >= 0) {
                    baos.write(buf, 0, n);
                }
                string = "try { " + baos.toString() + "} catch (Throwable t) { t.printStackTrace(); throw t; }";
                Object var9_8 = null;
                if (is == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var9_9 = null;
                    if (is != null) {
                        is.close();
                    }
                    if (baos == null) break block7;
                    baos.close();
                }
                throw throwable;
            }
            is.close();
        }
        if (baos != null) {
            baos.close();
        }
        return string;
    }

    private void handleError(HttpServletRequest request, HttpServletResponse response, Throwable t) {
        String msg = t.getMessage();
        log.severe(msg);
        log.throwing(((Object)((Object)this)).getClass().getName(), "unknown", t);
        try {
            if (t instanceof FileNotFoundException) {
                response.sendError(404, msg);
            } else {
                response.sendError(400, msg);
            }
        }
        catch (IOException e) {
            log.severe(e.getMessage());
            log.throwing(((Object)((Object)this)).getClass().getName(), "handleError", e);
        }
    }
}

