/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.protocol;

import com.funambol.framework.core.AbstractCommand;
import com.funambol.framework.core.Alert;
import com.funambol.framework.core.Chal;
import com.funambol.framework.core.Cred;
import com.funambol.framework.core.Data;
import com.funambol.framework.core.Item;
import com.funambol.framework.core.NextNonce;
import com.funambol.framework.core.RepresentationException;
import com.funambol.framework.core.Results;
import com.funambol.framework.core.Source;
import com.funambol.framework.core.SourceRef;
import com.funambol.framework.core.Status;
import com.funambol.framework.core.SyncBody;
import com.funambol.framework.core.SyncHdr;
import com.funambol.framework.core.SyncML;
import com.funambol.framework.core.Target;
import com.funambol.framework.core.TargetRef;
import com.funambol.framework.core.Util;
import com.funambol.framework.protocol.Flags;
import com.funambol.framework.protocol.ProtocolException;
import com.funambol.framework.protocol.ProtocolUtil;
import com.funambol.framework.protocol.SyncPackage;
import com.funambol.framework.protocol.v11.BasicRequirements;
import com.funambol.framework.protocol.v11.Errors;
import com.funambol.framework.protocol.v11.ManagementActionsRequirements;
import java.util.ArrayList;

public class ManagementActions
extends SyncPackage
implements Flags,
Errors {
    private Cred serverCredentials;
    private Alert sessionAbortAlert = null;
    private int authorizedStatusCode = 200;
    private String mimeType = null;
    private String clientAuthType = null;
    private NextNonce nextNonce = null;
    private AbstractCommand[] managementCommands = null;
    private AbstractCommand[] clientCommands = null;

    public void setServerCredentials(Cred serverCredentials) {
        this.serverCredentials = serverCredentials;
    }

    public Cred getServerCredentials() {
        return this.serverCredentials;
    }

    public ManagementActions(SyncHdr syncHeader, SyncBody syncBody) throws ProtocolException {
        super(syncHeader, syncBody);
        this.checkRequirements();
        this.checkSessionAbortRequired(syncBody);
    }

    public boolean isSessionAbortRequired() {
        return this.sessionAbortAlert != null;
    }

    public void setAuthorizedStatusCode(int authorizedStatusCode) {
        this.authorizedStatusCode = authorizedStatusCode;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setClientAuthType(String authType) {
        this.clientAuthType = authType;
    }

    public void setNextNonce(NextNonce nextNonce) {
        this.nextNonce = nextNonce;
    }

    public AbstractCommand[] getManagementCommands() {
        return this.managementCommands;
    }

    public void setManagementCommands(AbstractCommand[] managementCommands) {
        this.managementCommands = managementCommands;
    }

    public AbstractCommand[] getClientCommands() {
        return this.clientCommands;
    }

    public void setClientCommands(AbstractCommand[] commands) {
        this.clientCommands = commands;
    }

    @Override
    public void checkHeaderRequirements() throws ProtocolException {
        BasicRequirements.checkDTDVersion(this.syncHeader.getVerDTD());
        BasicRequirements.checkProtocolVersion(this.syncHeader.getVerProto());
        BasicRequirements.checkSessionId(this.syncHeader.getSessionID());
        BasicRequirements.checkMessageId(this.syncHeader.getMsgID());
        BasicRequirements.checkTarget(this.syncHeader.getTarget());
        BasicRequirements.checkSource(this.syncHeader.getSource());
    }

    @Override
    public void checkBodyRequirements() throws ProtocolException {
        this.clientCommands = this.syncBody.getCommands().toArray(new AbstractCommand[0]);
        ArrayList<AbstractCommand> results = ProtocolUtil.filterCommands(this.clientCommands, Results.class);
        if (results.size() > 0) {
            ManagementActionsRequirements.checkResults(results);
        }
    }

    public Results[] getResults() {
        ArrayList<AbstractCommand> ret = ProtocolUtil.filterCommands(this.clientCommands, Results.class);
        return ret.toArray(new Results[ret.size()]);
    }

    @Override
    public SyncML getResponse(String msgId) throws ProtocolException {
        ArrayList<AbstractCommand> responseCommandList = new ArrayList<AbstractCommand>();
        if (this.idGenerator == null) {
            throw new NullPointerException("The id generator is null. Please set a value for idGenerator");
        }
        if (!this.syncHeader.isNoResp()) {
            TargetRef[] targetRefs = new TargetRef[]{new TargetRef(this.syncHeader.getTarget().getLocURI())};
            SourceRef[] sourceRefs = new SourceRef[]{new SourceRef(this.syncHeader.getSource().getLocURI())};
            Chal chal = null;
            if ("syncml:auth-MAC".equalsIgnoreCase(this.clientAuthType)) {
                chal = Chal.getHMACChal();
                chal.setNextNonce(this.nextNonce);
            }
            Status statusCommand = new Status(this.idGenerator.next(), this.syncHeader.getMsgID(), "0", "SyncHdr", targetRefs, sourceRefs, null, chal, new Data(this.authorizedStatusCode), new Item[0]);
            responseCommandList.add(statusCommand);
        }
        if (this.isFlag(9)) {
            Alert abortAlert = new Alert(this.idGenerator.next(), false, null, 1223, new Item[0]);
            responseCommandList.add(abortAlert);
        } else {
            int i;
            int numClientCommand = this.clientCommands.length;
            AbstractCommand command = null;
            TargetRef[] targetRefs = null;
            SourceRef[] sourceRefs = null;
            Status statusCommand = null;
            boolean hasLargeObject = false;
            Long itemSize = null;
            for (i = 0; i < numClientCommand; ++i) {
                command = this.clientCommands[i];
                if (command.isNoResp() || command instanceof Status) continue;
                int status = 200;
                hasLargeObject = ProtocolUtil.hasLargeObject(command);
                if (command instanceof Results) {
                    ArrayList<Item> itemsList = ((Results)command).getItems();
                    if (!itemsList.isEmpty()) {
                        itemSize = Util.getItemSize(itemsList.get(itemsList.size() - 1));
                    }
                    if (!hasLargeObject) {
                        Long realSize;
                        if (itemSize == null || itemSize.equals(realSize = Util.getRealItemSize(itemsList.get(0), this.mimeType))) continue;
                        status = 424;
                    } else {
                        status = itemSize == null ? 412 : 213;
                    }
                }
                targetRefs = null;
                sourceRefs = null;
                String commandReference = command.getCmdID().getCmdID();
                Item[] items = new Item[]{};
                statusCommand = new Status(this.idGenerator.next(), this.syncHeader.getMsgID(), commandReference, command.getName(), targetRefs, sourceRefs, null, null, new Data(status), items);
                responseCommandList.add(statusCommand);
            }
            if (this.sessionAbortAlert == null) {
                if (!this.isFlag(8)) {
                    for (i = 0; this.managementCommands != null && i < this.managementCommands.length; ++i) {
                        responseCommandList.add(this.managementCommands[i]);
                    }
                } else {
                    Alert moreMsg = new Alert(this.idGenerator.next(), false, null, 1222, null);
                    responseCommandList.add(moreMsg);
                    this.unsetFlag(3);
                }
            }
        }
        Target target = new Target(this.syncHeader.getSource().getLocURI(), this.syncHeader.getSource().getLocName());
        Source source = new Source(this.syncHeader.getTarget().getLocURI(), this.syncHeader.getTarget().getLocName());
        SyncHdr responseHeader = new SyncHdr(this.getDTDVersion(), this.getProtocolVersion(), this.syncHeader.getSessionID(), msgId, target, source, null, false, this.serverCredentials, null);
        AbstractCommand[] commands = null;
        int numCommand = responseCommandList.size();
        commands = numCommand == 0 ? new AbstractCommand[1] : new AbstractCommand[numCommand];
        for (int i = 0; i < numCommand; ++i) {
            commands[i] = (AbstractCommand)responseCommandList.get(i);
        }
        SyncBody responseBody = new SyncBody(commands, this.isFlag(3));
        try {
            return new SyncML(responseHeader, responseBody);
        }
        catch (RepresentationException e) {
            throw new ProtocolException("Unexpected error", e);
        }
    }

    private void checkSessionAbortRequired(SyncBody syncBody) {
        AbstractCommand[] allClientCommands = syncBody.getCommands().toArray(new AbstractCommand[0]);
        ArrayList<AbstractCommand> alertList = ProtocolUtil.filterCommands(allClientCommands, Alert.class);
        int size = alertList.size();
        Alert[] alerts = new Alert[size];
        for (int i = 0; i < size; ++i) {
            alerts[i] = (Alert)alertList.get(i);
            if (alerts[i].getData() != 1223) continue;
            this.sessionAbortAlert = alerts[i];
            return;
        }
        this.sessionAbortAlert = null;
    }
}

