#!/usr/local/bin/perl

use strict;
use warnings;
use File::Basename;
use File::Find::Rule;
use File::Slurp;
use Getopt::Long;
use Readonly;
use UTF8BOM;

Readonly my $license => './license.txt';
Readonly my $base    => '../';
Readonly my @result  => File::Find::Rule->file()->name('*.cs')->in($base);

my ( $add, $strip ) = ( 0, 0 );
GetOptions(
    '--add' => \$add,
    '--strip' => \$strip
) or die Getopt::Long::HelpMessage(2);

if ( $add ) {
    my $license = read_file $license;
    for my $path ( @result ) {
				my $content = read_file $path or die "$path: $!";
        my $text = $license . UTF8BOM->remove_from_str($content);
        write_file $path, \$text or die "$path: $!";
    }
}
elsif ( $strip ) {
    for my $path ( @result ) {
        my $text = read_file $path or die "$path: $!";
				$text = UTF8BOM->remove_from_str($text);
        $text =~ s|\A/\*.*?\*/\r?\n||xms;
        write_file $path, \$text or die "$path: $!";
    }
}
else {
    my $self = basename($0);
    print STDOUT "usage: $self: [--add] [--strip]", "\n";
    exit(1);
}
exit(0);

