package jp.sourceforge.ocmml.android.modulators;

public final class Sine extends Modulator {
    private static void initialize() {
        if (!sInitialized) {
            double d0 = 2.0 * Math.PI / TABLE_LENGTH, p0 = 0;
            for (int i = 0; i < TABLE_LENGTH; i++) {
                sTable[i] = Math.sin(p0);
                p0 += d0;
            }
            sInitialized = true;
        }
    }

    public Sine() {
        super();
        initialize();
    }

    public double getNextSampleOfs(int ofs) {
        double value = sTable[((mPhase + ofs) & PHASE_MASK) >> PHASE_SHIFT];
        addPhase(1);
        return value;
    }

    @Override
    public double getNextSample() {
        double value = sTable[mPhase >> PHASE_SHIFT];
        addPhase(1);
        return value;
    }

    private static Boolean sInitialized = false;
    private static double[] sTable = new double[TABLE_LENGTH];
}
