﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices; // DllImport
using System.IO;
//using Microsoft.Win32;            // Path


namespace nodokaGuiEdit
{
    public partial class FormSetNODOKA : Form
    {
        public FormSetNODOKA()
        {
            InitializeComponent();
            string viewPath = System.Environment.GetEnvironmentVariable("NODOKA", System.EnvironmentVariableTarget.User);

            textBox2.Text = viewPath;

            if (viewPath == null)
            {
                viewPath = "未設定";
            }

            textBox1.Text = viewPath;
        }

        public class Global_Val
        {
            // グローバル変数の宣言
            static public string envString;
        }

        private void Getbutton_Click(object sender, EventArgs e)
        {
            // 参照ボタンが押された
            // File Open Dialog
            string folder_name = String.Empty;

            OpenFileDialog OF_Dialog = new OpenFileDialog();
            OF_Dialog.FileName = string.Empty;
            OF_Dialog.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.UserProfile);
            OF_Dialog.Filter =
                "すべてのファイル(*.*)|*.*";
            OF_Dialog.FilterIndex = 1;
            OF_Dialog.Title = "環境変数NODOKAに設定するフォルダに存在するファイルを選択してください";
            OF_Dialog.RestoreDirectory = true;
            OF_Dialog.CheckFileExists = false;
            OF_Dialog.CheckPathExists = true;
            OF_Dialog.Multiselect = false;

            if (OF_Dialog.ShowDialog() == DialogResult.OK)
            {
                // file name取得
                folder_name = Path.GetDirectoryName(OF_Dialog.FileName);

                textBox2.Text = folder_name;
            }



        }

        private void SetNODOKAclosing(object sender, FormClosingEventArgs e)
        {
            // Global_Valに残す。
            Global_Val.envString = textBox2.Text;
        }
    }
}

