﻿//-------------------------------------------------------------------------
// Main Form
//
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: Timer.cs 766 2010-09-11 08:00:14Z kintoki $
//-------------------------------------------------------------------------
using System;
using System.Diagnostics;

namespace NicoLive
{
    partial class Form1
    {
        //-------------------------------------------------------------------------
        // タイマー
        //-------------------------------------------------------------------------
        private void UITimer_Tick(object sender, EventArgs e)
        {
            Properties.Settings.Default.last_lv = this.mLiveID.Text;

            // ログイン状態更新
            UpdateLogin();

            // コメントサーバーとの接続キープ用
            if (mNico != null && mNico.IsLogin && 
                !CheckStatus(STATUS_FLAGS.DISCONNECT) &&
                CheckStatus(STATUS_FLAGS.OWN_LIVE) && 
                !mNico.WakutoriMode)
            {
                TimeSpan ts = DateTime.Now - this.mLastChatTime;
                if (ts.Minutes > KEEP_ALIVE_TIME)
                {
                    SendComment("/keepalive", true);
                    mLastChatTime = DateTime.Now;
                }
            }

            // ガベージ・コレクション
            mNextGC++;
            if (mNextGC > 600 * 3)
            {
                Debug.WriteLine("GC PRE :" + GC.GetTotalMemory(false));
                GC.Collect();
                Debug.WriteLine("GC POST:" + GC.GetTotalMemory(false));
                mNextGC = 0;
            }
        }
    }
}
//-------------------------------------------------------------------------
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: Timer.cs 766 2010-09-11 08:00:14Z kintoki $
//-------------------------------------------------------------------------
