using System;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using MikuMikuDance.XNA.Stages;

namespace MikuMikuDance.XNA.ShadowMap
{
    /// <summary>
    /// fvXobt@VhE}bvpVhE}bv}l[WB
    /// </summary>
    /// <remarks>
    /// MMDɂ͂ɑ郂[h͂ȂB
    /// ԂႯƉ̂ŎgɂȂȂAvNXB
    /// </remarks>
    internal class DepthBufferShadowMap : IShadowMapManager
    {
        //VhE(mmd̃VhE90炢ɑ)
        float m_ShadowDist = 250f;// 88.70f;
        /// <summary>
        /// VhE
        /// </summary>
        public float ShadowDist { get { return m_ShadowDist; } set { m_ShadowDist = value; } }

        float m_LightDist = 50;
        /// <summary>
        /// Cg
        /// </summary>
        public float LightDist { get { return m_LightDist; } set { m_LightDist = value; } }

        //obt@
        const int NumBuf = 2;
        int bufIndex = 0;
        RenderTarget2D[] shadowRenderTarget;
        DepthStencilBuffer[] shadowDepthBuffer;
        //̃R[i[
        Vector3[] frustumCorners = new Vector3[BoundingBox.CornerCount];

        /// <summary>
        /// _O^[Qbg
        /// </summary>
        public RenderTarget2D RenderTarget { get { return shadowRenderTarget[bufIndex]; } }
        /// <summary>
        /// fvXobt@
        /// </summary>
        public DepthStencilBuffer DepthBuffer { get { return shadowDepthBuffer[bufIndex]; } }

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="graphicsDevice">OtBbNXfoCX</param>
        /// <param name="SizeMul">{TCỸVhE}bv𐶐邩</param>
        public DepthBufferShadowMap(GraphicsDevice graphicsDevice, float SizeMul)
        {
            if (SizeMul < 0.01)
                throw new ApplicationException("SizeMul܂͏܂");
            SurfaceFormat shadowMapFormat = SurfaceFormat.Unknown;

            // 32bitA16bitǂɑΉĂ邩`FbN
            if (GraphicsAdapter.DefaultAdapter.CheckDeviceFormat(DeviceType.Hardware,
                               GraphicsAdapter.DefaultAdapter.CurrentDisplayMode.Format,
                               TextureUsage.Linear, QueryUsages.None,
                               ResourceType.RenderTarget, SurfaceFormat.Single) == true)
            {
                shadowMapFormat = SurfaceFormat.Single;
            }
            else if (GraphicsAdapter.DefaultAdapter.CheckDeviceFormat(
                               DeviceType.Hardware,
                               GraphicsAdapter.DefaultAdapter.CurrentDisplayMode.Format,
                               TextureUsage.Linear, QueryUsages.None,
                               ResourceType.RenderTarget, SurfaceFormat.HalfSingle)
                               == true)
            {
                shadowMapFormat = SurfaceFormat.HalfSingle;
            }
            shadowRenderTarget = new RenderTarget2D[NumBuf];
            shadowDepthBuffer = new DepthStencilBuffer[NumBuf];
            PresentationParameters pp = graphicsDevice.PresentationParameters;
            int width = (int)(pp.BackBufferWidth * SizeMul);
            int height = (int)(pp.BackBufferHeight * SizeMul);

            for (int i = 0; i < NumBuf; i++)
            {
                //_eNX`쐬
                shadowRenderTarget[i] = new RenderTarget2D(graphicsDevice,
                                                        width,
                                                        height,
                                                        1, shadowMapFormat);

                //VhE}bvp̃fvXobt@擾
                shadowDepthBuffer[i] = new DepthStencilBuffer(graphicsDevice,
                                                        width,
                                                        height,
                                                        DepthFormat.Depth24);
            }
        }
        /// <summary>
        /// tbv
        /// </summary>
        public void Flip()
        {
            if (++bufIndex >= NumBuf)
                bufIndex = 0;
        }
        DepthStencilBuffer oldDepthBuf = null;
        /// <summary>
        /// VhE}bv̕`̊Jn
        /// </summary>
        /// <param name="graphicDevice">OtBbNfoCX</param>
        public void BeginShadowMap(GraphicsDevice graphicDevice)
        {
            if (oldDepthBuf != null)
                throw new ApplicationException("BeginShadowMapĂяo܂");
            //tbv(Ot[̏IĂȂꍇAG[ƂȂ邽)
            Flip();
            //_O^[Qbg؂ւ
            graphicDevice.SetRenderTarget(0, RenderTarget);
            //[xobt@ޔ
            oldDepthBuf = graphicDevice.DepthStencilBuffer;
            //[xobt@Zbg
            graphicDevice.DepthStencilBuffer = DepthBuffer;
        }
        /// <summary>
        /// VhE}bv̕`̏I
        /// </summary>
        /// <param name="graphicDevice">OtBbNfoCX</param>
        public void EndShadowMap(GraphicsDevice graphicDevice)
        {
            EndShadowMap(null, graphicDevice);
        }
        /// <summary>
        /// VhE}bv̕`̏I
        /// </summary>
        /// <param name="nextTarget">Ɏgp郌_O^[Qbg</param>
        /// <param name="graphicDevice">OtBbNfoCX</param>
        public void EndShadowMap(RenderTarget2D nextTarget, GraphicsDevice graphicDevice)
        {
            if (oldDepthBuf == null)
                throw new ApplicationException("BeginShadowMapĂяoOEndShadowMapĂяo܂");
            //_O^[Qbg؂ւ
            graphicDevice.SetRenderTarget(0, nextTarget);
            //[xobt@߂
            graphicDevice.DepthStencilBuffer = oldDepthBuf;
            oldDepthBuf = null;
        }

        /// <summary>
        /// VhE}bv擾
        /// </summary>
        /// <return>eNX`</return>
        public Texture2D GetShadowMap(out Vector2 offset)
        {
            Texture2D texture;
            texture = shadowRenderTarget[bufIndex].GetTexture();
            offset = new Vector2(0.5f / (float)texture.Width, 0.5f / (float)texture.Height);
            return texture;
        }
        /// <summary>
        /// VhE}bvp̌猩ViewProj}gNX̍쐬
        /// </summary>
        /// <param name="Camera">J</param>
        /// <param name="LightManager">Cg}l[W</param>
        /// <param name="graphics">OtBbNfoCX</param>
        /// <param name="View">ViewMatrix̏o</param>
        /// <param name="Proj">ProjMatrix̏o</param>
        public void CreateLightViewProjMatrix(IMMDCamera Camera, IMMDLightManager LightManager, GraphicsDevice graphics, out Matrix View, out Matrix Proj)
        {
            //\sݒ
            Vector3 lightDir = -LightManager.KeyLight.Direction;
            lightDir.Normalize();
            
            //Cg̈ʒuvZ
            Vector3 lightPosition = lightDir * LightDist;
            
            
            //Cg̈ʒuɂr[}gbNX
            View = Matrix.CreateLookAt(lightPosition, lightPosition - lightDir, Vector3.Up);
            
            //Cg̃vWFNV}gbNXg
            //s̏ꍇ͎̃vWFNVgBɂp[XyNeBuVhE}bvɂȂ
            float aspectRatio = (float)RenderTarget.Width / (float)RenderTarget.Height;
            Proj = Matrix.CreatePerspectiveFieldOfView(Camera.FieldOfView, aspectRatio, Camera.Near, ShadowDist*10);
        }
    }
}