// TemplateReader.cpp : R\[ AvP[ṼGg |Cg`܂B
//

#include "stdafx.h"

#include "TemplateEvaluater.h"

class __declspec(uuid("{B417501A-7DBA-414e-B68A-82F816B369A4}")) CTemplateSourceSplitter
	: public CComObjectRoot
	, public CComCoClass<CTemplateSourceSplitter, &__uuidof(CTemplateSourceSplitter)>
	, public ITemplateSourceSplitter
{
public:
	DECLARE_OBJECT_DESCRIPTION("CTemplateSourceSplitter")

	BEGIN_COM_MAP(CTemplateSourceSplitter)
		COM_INTERFACE_ENTRY(ITemplateSourceSplitter)
	END_COM_MAP()

	DECLARE_CLASSFACTORY()
	DECLARE_NO_REGISTRY()
	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct(void) throw()
	{
		return Reset();
	}

	void FinalRelease() throw()
	{
		pCollector_.Release();
	}

	virtual HRESULT __stdcall Reset() throw()
	{
		state_ = PARSE_STATE_INIT;
		leadByte_ = false;

		return S_OK;
	}

	virtual HRESULT __stdcall SetHandler(ITemplateSourceSeparateHandler* v_pCollector) throw()
	{
		try {
			pCollector_ = v_pCollector;
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	virtual HRESULT __stdcall GetHandler(ITemplateSourceSeparateHandler** v_ppCollector) throw()
	{
		return pCollector_.CopyTo(v_ppCollector);
	}

	virtual HRESULT __stdcall Parse(ISequentialStream* v_pStm) throw()
	{
		if ( !v_pStm) {
			return E_INVALIDARG;
		}
		if ( !pCollector_) {
			ATLASSERT(false);
			return E_FAIL;
		}
		
		const size_t bufsiz = 4096;
		BYTE buf[bufsiz];
		ULONG rdLen = 0;
		ULONG pos = 0;

		for (;;) {
			HRESULT hr;
			if (pos == rdLen) {
				hr = v_pStm->Read(buf, bufsiz, &rdLen);
				if (FAILED(hr)) {
					// ǂݍ݂Ɏs
					return hr;
				}
				pos = 0;
				if (rdLen == 0) {
					// EOFɓB
					hr = pCollector_->putBreak();
					if (FAILED(hr)) {
						return hr;
					}
					break;
				}
			}
			hr = Feed(buf[pos++]);
			if (FAILED(hr)) {
				return hr;
			}
		}

		return S_OK;
	}

protected:

	HRESULT Feed(BYTE c) throw()
	{
		// Shift_JISUTF-8œǂޏꍇALeadByte̔Ȃǂ̓ʂȏ͕svłB
		// SJIS\oCǵu1ڂ 0x81`0x9F  2ڂ 0x40`0x7E / 0x80`0xFCv
		// 邢́u1ڂ 0xE0`0xFC  2ڂ 0x40`0x7EvłA
		// <%>́A0x3c,0x25,0x3eŁASJIS1oCgځA2oCgڂ̑oɊYȂ̂ŖȂB
		// UTF-8̏ꍇł2oCgڈȍ~͑S0x80ȏɂȂ邽ߊYAȂB
		HRESULT hr = S_FALSE;
		switch (state_)
		{
		case PARSE_STATE_INIT:
		case PARSE_STATE_LITERAL:
			if (c == '<') {
				state_ = PARSE_STATE_BEGINTAG;
			}
			else {
				hr = pCollector_->putLiteral(c);
			}
			break;

		case PARSE_STATE_BEGINTAG:
			if (c == '%') {
				state_ = PARSE_STATE_SCRIPTLET;
				hr = pCollector_->putBreak();
			}
			else {
				state_ = PARSE_STATE_LITERAL;
				hr = pCollector_->putLiteral('<');
				if (SUCCEEDED(hr)) {
					hr = pCollector_->putLiteral(c);
				}
			}
			break;
		
		case PARSE_STATE_SCRIPTLET:
			if (c == '%') {
				state_ = PARSE_STATE_ENDTAG;
			}
			else {
				hr = pCollector_->putScriptlet(c);
			}
			break;
		
		case PARSE_STATE_ENDTAG:
			if (c == '>') {
				state_ = PARSE_STATE_INIT;
				hr = pCollector_->putBreak();
			}
			else {
				state_ = PARSE_STATE_SCRIPTLET;
				hr = pCollector_->putScriptlet('%');
				if (SUCCEEDED(hr)) {
					hr = pCollector_->putScriptlet(c);
				}
			}
			break;

		default:
			hr = E_FAIL;
			ATLASSERT(false);
		}

		return hr;
	}

	typedef enum {
		PARSE_STATE_INIT = 0,
		PARSE_STATE_LITERAL,
		PARSE_STATE_BEGINTAG,
		PARSE_STATE_SCRIPTLET,
		PARSE_STATE_ENDTAG,
	} PARSE_STATE;

	PARSE_STATE state_;
	BOOL leadByte_;

	CComPtr<ITemplateSourceSeparateHandler> pCollector_;
};

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CTemplateSourceSplitter), CTemplateSourceSplitter)


HRESULT __stdcall CreateTemplateSourceSplitter(
	ITemplateSourceSeparateHandler* v_pHandler,
	ITemplateSourceSplitter** v_ppTemplateSourceSplitter
	) throw()
{
	if ( !v_ppTemplateSourceSplitter) {
		return E_POINTER;
	}

	HRESULT hr;
	
	CComPtr<ITemplateSourceSplitter> pSplitter;
	hr = CTemplateSourceSplitter::CreateInstance(&pSplitter);
	if (FAILED(hr)) {
		return hr;
	}
	
	if (v_pHandler) {
		hr = pSplitter->SetHandler(v_pHandler);
		if (FAILED(hr)) {
			return hr;
		}
	}

	return pSplitter.CopyTo(v_ppTemplateSourceSplitter);
}
