#include "stdafx.h"

#include "TemplateEvaluater.h"

#include "SimpleBuffer.h"

class __declspec(uuid("{B70E3921-C5C6-49a6-8ACE-25CE855F4225}")) COutputStreamWriter
	: public CComObjectRoot
	, public CComCoClass<COutputStreamWriter, &__uuidof(COutputStreamWriter)>
	, public IOutputStreamWriter
{
public:
	DECLARE_OBJECT_DESCRIPTION("COutputStreamWriter")

	BEGIN_COM_MAP(COutputStreamWriter)
		COM_INTERFACE_ENTRY(IOutputStreamWriter)
		COM_INTERFACE_ENTRY(ITemplateSourceWriter2)
		COM_INTERFACE_ENTRY(ITemplateSourceWriter)
	END_COM_MAP()

	DECLARE_CLASSFACTORY()
	DECLARE_NO_REGISTRY()
	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct(void) throw()
	{
		codepage_ = GetACP();
		return S_OK;
	}

	///////////// ITemplateSourceWriter //////////////

	virtual HRESULT __stdcall Write(LPCWSTR v_pBuf, UINT v_siz, BOOL v_scriptlet) throw()
	{
		if ( !pStm_) {
			ATLASSERT(false);
			return E_FAIL;
		}

		if ( !v_pBuf || v_siz == 0) {
			return S_FALSE;
		}

		int required = WideCharToMultiByte(
			codepage_,
			0,
			v_pBuf,
			v_siz,
			NULL,
			0,
			NULL,
			NULL
			);
		if ( !required) {
			return AtlHresultFromLastError();
		}
		
		CSimpleBuffer<CHAR> buf(required);

		int ret = WideCharToMultiByte(
			codepage_,
			0,
			v_pBuf,
			v_siz,
			buf.GetData(),
			required,
			NULL,
			NULL
			);
		if ( !ret) {
			return AtlHresultFromLastError();
		}

		HRESULT hr;

		ULONG wd;
		if (v_scriptlet) {
			hr = Write(L"<%", 2, FALSE);
			if (FAILED(hr)) {
				return hr;
			}
		}

		hr = pStm_->Write(buf.GetData(), required, &wd);
		if (FAILED(hr)) {
			return hr;
		}
		if (wd != required) {
			return E_FAIL;
		}

		if (v_scriptlet) {
			hr = Write(L"%>", 2, FALSE);
			if (FAILED(hr)) {
				return hr;
			}
		}

		return S_OK;
	}

	///////////// ITemplateSourceWriter2 //////////////

	virtual HRESULT __stdcall set_Codepage(UINT v_codepage) throw()
	{
		if ( !IsValidCodePage(v_codepage)) {
			return E_INVALIDARG;
		}

		codepage_ = v_codepage;

		return S_OK;
	}

	virtual HRESULT __stdcall get_Codepage(UINT* v_pCodepage) throw()
	{
		if ( !v_pCodepage) {
			return E_POINTER;
		}

		*v_pCodepage = codepage_;

		return S_OK;
	}

	///////////// IOutputStreamWriter //////////////

	virtual HRESULT __stdcall SetStream(ISequentialStream* v_pStm) throw()
	{
		try {
			pStm_ = v_pStm;
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	virtual HRESULT __stdcall GetStream(ISequentialStream** v_ppStm) throw()
	{
		return pStm_.CopyTo(v_ppStm);
	}

protected:

	UINT codepage_;

	CComPtr<ISequentialStream> pStm_;
};

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(COutputStreamWriter), COutputStreamWriter)


HRESULT __stdcall CreateOutputStreamWriter(ISequentialStream* v_pStm, IOutputStreamWriter** v_ppWriter) throw()
{
	if ( !v_ppWriter) {
		return E_POINTER;
	}

	HRESULT hr;

	CComPtr<IOutputStreamWriter> pWriter;
	hr = COutputStreamWriter::CreateInstance(&pWriter);
	if (FAILED(hr)) {
		return hr;
	}

	if (v_pStm) {
		hr = pWriter->SetStream(v_pStm);
		if (FAILED(hr)) {
			return hr;
		}
	}

	return pWriter.CopyTo(v_ppWriter);
}
