#include "stdafx.h"

#include "NameAcceptor.h"

class __declspec(uuid("{7DD143A1-3E4D-4ea8-B722-40AEF180AF99}")) CStripedURLNameAcceptorAdaptor
	: public IStripedURLNameAcceptorAdaptor
	, public CComObjectRoot
	, public CComCoClass<CStripedURLNameAcceptorAdaptor, &__uuidof(CStripedURLNameAcceptorAdaptor)>
{
public:
	DECLARE_OBJECT_DESCRIPTION("CStripedURLNameAcceptorAdaptor Object")

	BEGIN_COM_MAP(CStripedURLNameAcceptorAdaptor)
		COM_INTERFACE_ENTRY(INameAcceptor)
		COM_INTERFACE_ENTRY(IStripedURLNameAcceptorAdaptor)
	END_COM_MAP( )

	DECLARE_CLASSFACTORY()
	DECLARE_NO_REGISTRY()

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	virtual HRESULT __stdcall IsAcceptable(LPCWSTR v_pName) throw()
	{
		if ( !pExtFilter_) {
			return S_FALSE;
		}

		try {
			CComBSTR extName;

			HRESULT hr = CreateStripedURLName(v_pName, &extName);
			if (FAILED(hr)) {
				return hr;
			}

			return pExtFilter_->IsAcceptable(extName);
		}
		catch (...) {
			return E_FAIL;
		}
	}

	///

	virtual HRESULT __stdcall put_INameAcceptor(INameAcceptor* v_pNameAcceptor) throw()
	{
		try {
			pExtFilter_ = v_pNameAcceptor;
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	virtual HRESULT __stdcall get_INameAcceptor(INameAcceptor** v_ppNameAcceptor) throw()
	{
		return pExtFilter_.CopyTo(v_ppNameAcceptor);
	}

protected:

	CComPtr<INameAcceptor> pExtFilter_;
};

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CStripedURLNameAcceptorAdaptor), CStripedURLNameAcceptorAdaptor);


HRESULT __stdcall CreateStripedURLNameAcceptorAdaptor(INameAcceptor* v_pAcceptor,
													  IStripedURLNameAcceptorAdaptor** v_ppAdaptor) throw()
{
	HRESULT hr;

	CComPtr<IStripedURLNameAcceptorAdaptor> pAdaptor;
	hr = CStripedURLNameAcceptorAdaptor::CreateInstance(&pAdaptor);
	if (FAILED(hr)) {
		return hr;
	}

	if (v_pAcceptor) {
		hr = pAdaptor->put_INameAcceptor(v_pAcceptor);
		if (FAILED(hr)) {
			return hr;
		}
	}

	return pAdaptor.CopyTo(v_ppAdaptor);
}

HRESULT __stdcall CreateStripedURLName(LPCWSTR v_pName, BSTR* v_pStripedName) throw()
{
	if ( !v_pStripedName) {
		return E_POINTER;
	}

	try {
		ATLASSERT( !*v_pStripedName);
		*v_pStripedName = NULL;

		if ( !v_pName) {
			return S_FALSE;
		}

		// I[̌o (sA܂̓NG[܂)
		LPCWSTR p = v_pName;
		while (*p) {
			if (*p == '?') {
				break;
			}
			p = CharNext(p);
		}
		LPCWSTR pEn = p;

		// t@Čo (Ō̃tH_vCXA͐擪)
		LPCWSTR pSt = v_pName;
		for(;;) {
			if (*p == '\\' || *p == '/') {
				pSt = CharNext(p);
				break;
			}
			if (p == v_pName) {
				break;
			}
			p = CharPrev(v_pName, p);
		}

		// O̐؂o
		const int len = static_cast<int>(pEn - pSt);
		if (len == 0) {
			return S_FALSE;
		}

		CComBSTR stripedName(len, pSt);

		*v_pStripedName = stripedName.Detach();
		return S_OK;
	}
	catch (...) {
		return E_FAIL;
	}
}
