#include "stdafx.h"

#include "TemplateConfig.h"

class __declspec(uuid("{32AA01E8-7852-4195-A48C-A039018F3DBF}")) CTemplateConfig
	: public CComObjectRoot
	, public ITemplateConfig
{
public:
	BEGIN_COM_MAP(CTemplateConfig)
		COM_INTERFACE_ENTRY(ITemplateConfig)
	END_COM_MAP( )

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct() throw()
	{
		maxIFrame_ = 0;

		return S_OK;
	}

	/// ITemplateConfig ///

	/**
	 * ev[gʂ邽߂́Aӂ̎ʖB
	 * @param v_pName Oi[|C^
	 * @return HR
	 */
	virtual HRESULT __stdcall GetName(BSTR* v_pName) throw()
	{
		return name_.CopyTo(v_pName);
	}

	/**
	 * ev[g̕\
	 * @param v_pName Oi[|C^
	 * @return HR
	 */
	virtual HRESULT __stdcall GetDisplayName(BSTR* v_pName) throw()
	{
		return displayName_.CopyTo(v_pName);
	}

	/**
	 * ev[g̃t@C
	 * @param v_pFileName t@Ci[|C^
	 * @return HR
	 */
	virtual HRESULT __stdcall GetFileName(BSTR* v_pFileName) throw()
	{
		return fileName_.CopyTo(v_pFileName);
	}

	/**
	 * o͂t@CɂĕێłIFrame̐苖eB
	 * ̐ĺAo͂y[W̃fUCɂăNCAgׂ̕܂邱Ƃ
	 * ؂邱Ƃɂ܂BfUCɂAIFrameΏۃACeXChV[A
	 * 邢̓NƂĕ\ꍇɂ͋e͑傫邱Ƃł܂B
	 * ̒l̏ꍇIFrameߑȕׂƂȂɂߌ؂xsvł邱Ƃ܂B
	 * @param v_pMaxIFrame 苖ei[|C^
	 */
	virtual HRESULT __stdcall GetMaxIFrame(int* v_pMaxIFrame) throw()
	{
		if ( !v_pMaxIFrame) {
			return E_POINTER;
		}

		*v_pMaxIFrame = maxIFrame_;

		return S_OK;
	}

	//// 

	void SetName(LPCWSTR v_pName)
	{
		if ( !v_pName) {
			v_pName = L"";
		}
		name_ = v_pName;
	}

	void SetDisplayName(LPCWSTR v_pDisplayName)
	{
		if ( !v_pDisplayName) {
			v_pDisplayName = L"";
		}
		displayName_ = v_pDisplayName;
	}

	void SetFileName(LPCWSTR v_pFileName)
	{
		if ( !v_pFileName) {
			v_pFileName = L"";
		}
		fileName_ = v_pFileName;
	}

	void SetMaxIFrame(int v_maxIFrame)
	{
		maxIFrame_ = v_maxIFrame;
	}

protected:

	CComBSTR name_;

	CComBSTR displayName_;

	CComBSTR fileName_;

	int maxIFrame_;

};


class __declspec(uuid("{143D2BE7-5C90-4907-8B38-672791D1109B}")) CTemplateConfigFactory
	: public CComObjectRoot
	, public CComCoClass<CTemplateConfigFactory, &__uuidof(CTemplateConfigFactory)>
	, public ITemplateConfigFactory
{
public:
	DECLARE_OBJECT_DESCRIPTION("MkImgPage CTemplateConfigFactoryr Object")

	BEGIN_COM_MAP(CTemplateConfigFactory)
		COM_INTERFACE_ENTRY(ITemplateConfigFactory)
	END_COM_MAP( )

	DECLARE_CLASSFACTORY()
	DECLARE_NO_REGISTRY()

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct() throw()
	{
		return S_OK;
	}

	/// ITemplateConfigFactory ///

	virtual HRESULT __stdcall CreateTemplateConfig(ITemplateConfig** v_ppTemplateConfig) throw()
	{
		if ( !v_ppTemplateConfig) {
			return E_POINTER;
		}
		try {
			HRESULT hr;
			CComObject<CTemplateConfig>* pConfigImpl = NULL;
			hr = CComObject<CTemplateConfig>::CreateInstance(&pConfigImpl);
			if (FAILED(hr)) {
				return hr;
			}
			CComPtr<ITemplateConfig> pConfig(pConfigImpl);
			ATLASSERT(pConfig);

			CAtlStringW fileName;
			if ( !fileName_.IsEmpty()) {
				if ( !baseDir_.IsEmpty()) {
					fileName += baseDir_;
				}
				fileName += fileName_;
			}

			pConfigImpl->SetName(name_);
			pConfigImpl->SetDisplayName(displayName_);
			pConfigImpl->SetFileName(fileName);
			pConfigImpl->SetMaxIFrame(maxIFrame_);

			return pConfig.CopyTo(v_ppTemplateConfig);
		}
		catch (const CAtlException& exception) {
			return exception.m_hr;
		}
		catch (...) {
			return E_FAIL;
		}
	}

	virtual HRESULT __stdcall Reset(void) throw()
	{
		try {
			name_.Empty();
			displayName_.Empty();
			fileName_.Empty();
			maxIFrame_ = 0;
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	virtual HRESULT __stdcall SetBaseDirectory(LPCWSTR v_pBaseDir) throw()
	{
		try {
			if ( !v_pBaseDir) {
				v_pBaseDir = L"";
			}
			baseDir_ = v_pBaseDir;
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	virtual HRESULT __stdcall SetName(LPCWSTR v_pName) throw()
	{
		try {
			if ( !v_pName) {
				v_pName = L"";
			}
			name_ = v_pName;
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	virtual HRESULT __stdcall SetDisplayName(LPCWSTR v_pName) throw()
	{
		try {
			if ( !v_pName) {
				v_pName = L"";
			}
			displayName_ = v_pName;
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	virtual HRESULT __stdcall SetFileName(LPCWSTR v_pFileName) throw()
	{
		try {
			if ( !v_pFileName) {
				v_pFileName = L"";
			}
			fileName_ = v_pFileName;
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	virtual HRESULT __stdcall SetMaxIFrame(int v_maxIFrame) throw()
	{
		try {
			maxIFrame_ = v_maxIFrame;
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

private:

	CAtlStringW baseDir_;

	CAtlStringW name_;

	CAtlStringW displayName_;

	CAtlStringW fileName_;

	int maxIFrame_;

};

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CTemplateConfigFactory), CTemplateConfigFactory);


HRESULT __stdcall CreateTemplateConfigFactory(ITemplateConfigFactory** v_ppTemplateConfigFactory) throw()
{
	return CTemplateConfigFactory::CreateInstance(v_ppTemplateConfigFactory);
}

HRESULT __stdcall LoadTemplateConfig(IConfStrage* v_pConfStrage,
									 ITemplateConfigFactory* v_pFactory,
									 ITemplateConfig* v_pDefaultConfig,
									 ITemplateConfig** v_ppTemplateConfig) throw()
{
	if ( !v_pConfStrage || !v_pFactory) {
		return E_INVALIDARG;
	}
	if ( !v_ppTemplateConfig) {
		return E_POINTER;
	}
	ATLASSERT( !*v_ppTemplateConfig);

	try {
		HRESULT hr;

		hr = v_pFactory->Reset();
		if (FAILED(hr)) return hr;


		CComBSTR fileName;
		hr = v_pConfStrage->GetString(L"TemplateFileName", L"", &fileName);
		if (FAILED(hr)) return hr;

		CComBSTR name;
		hr = v_pConfStrage->GetString(L"TemplateName", L"", &name);
		if (FAILED(hr)) return hr;

		// OȗꂽꍇAZNVpB
		if ( !name || name.Length() == 0) {
			CComQIPtr<IConfNamedStrage> pNamedStrage(v_pConfStrage);
			if ( !pNamedStrage) {
				// IConfNamedStrageĂȂ
				ATLASSERT(false);
				return E_FAIL;
			}
			name.Empty();
			hr = pNamedStrage->GetName(&name);
			if (FAILED(hr)) return hr;
		}

		CComBSTR displayName;
		hr = v_pConfStrage->GetString(L"TemplateDisplayName", L"", &displayName);
		if (FAILED(hr)) return hr;

		// \ȗꂽꍇAOƓɂ
		if ( !displayName || displayName.Length() == 0) {
			displayName = name;
		}

		int maxIFrameDefault = 20; // MAX_IFRAMȄl20
		if (v_pDefaultConfig) {
			hr = v_pDefaultConfig->GetMaxIFrame(&maxIFrameDefault);
			if (FAILED(hr)) return hr;
		}
		int maxIFrame = 0;
		hr = v_pConfStrage->GetInt(L"MAX_IFRAME", maxIFrameDefault, &maxIFrame);
		if (FAILED(hr)) return hr;



		hr = v_pFactory->SetName(name);
		if (FAILED(hr)) return hr;

		hr = v_pFactory->SetDisplayName(displayName);
		if (FAILED(hr)) return hr;

		hr = v_pFactory->SetFileName(fileName);
		if (FAILED(hr)) return hr;

		hr = v_pFactory->SetMaxIFrame(maxIFrame);
		if (FAILED(hr)) return hr;

		return v_pFactory->CreateTemplateConfig(v_ppTemplateConfig);
	}
	catch (const CAtlException& exception) {
		ATLASSERT(false);
		return exception.m_hr;
	}
	catch (...) {
		ATLASSERT(false);
		return E_FAIL;
	}
}


class __declspec(uuid("{562113AB-2688-4c2d-9FFD-D90769C5D7E9}")) CTemplateConfigCollection
	: public CComObjectRoot
	, public ITemplateConfigCollection
{
public:
	BEGIN_COM_MAP(CTemplateConfigFactory)
		COM_INTERFACE_ENTRY(ITemplateConfigFactory)
	END_COM_MAP( )

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct() throw()
	{
		return S_OK;
	}

	void FinalRelease() throw()
	{
		pConfigList_.RemoveAll();
	}

	/// ITemplateConfigCollection ///

	virtual HRESULT __stdcall GetCount(size_t* v_pCount) throw()
	{
		if ( !v_pCount) {
			return E_POINTER;
		}
		try {
			*v_pCount = pConfigList_.GetCount();
		}
		catch (...) {
			ATLASSERT(false);
			return E_FAIL;
		}
		return S_OK;
	}

	virtual HRESULT __stdcall FindTemplateConfig(LPCWSTR v_pName, ITemplateConfig** v_ppTemplateConfig) throw()
	{
		if ( !v_pName || !*v_pName) {
			return E_INVALIDARG;
		}
		if ( !v_ppTemplateConfig) {
			return E_POINTER;
		}
		try {
			ATLASSERT(!*v_ppTemplateConfig);
			*v_ppTemplateConfig = NULL;

			POSITION pos = pConfigList_.GetHeadPosition();
			while (pos) {
				CComPtr<ITemplateConfig>& pConfig = pConfigList_.GetNext(pos);
				CComBSTR name;
				HRESULT hr = pConfig->GetName(&name);
				if (FAILED(hr)) {
					return hr;
				}
				if (name == v_pName) {
					return pConfig.CopyTo(v_ppTemplateConfig);
				}
			}
		}
		catch (const CAtlException& exception) {
			ATLASSERT(false);
			return exception.m_hr;
		}
		catch (...) {
			ATLASSERT(false);
			// fall through
		}
		return E_FAIL;
	}

	virtual HRESULT __stdcall GetTemplateConfig(size_t v_idx, ITemplateConfig** v_ppTemplateConfig) throw()
	{
		if ( !v_ppTemplateConfig) {
			return E_POINTER;
		}
		try {
			ATLASSERT(!*v_ppTemplateConfig);
			*v_ppTemplateConfig = NULL;

			const size_t mx = pConfigList_.GetCount();
			if (v_idx >= 0 && v_idx < mx) {
				POSITION pos = pConfigList_.FindIndex(v_idx);
				if (pos) {
					CComPtr<ITemplateConfig>& pConfig = pConfigList_.GetAt(pos);
					return pConfig.CopyTo(v_ppTemplateConfig);
				}
			}
		}
		catch (const CAtlException& exception) {
			ATLASSERT(false);
			return exception.m_hr;
		}
		catch (...) {
			ATLASSERT(false);
			// fall through
		}
		return E_FAIL;
	}

	void Append(ITemplateConfig* v_pConfig)
	{
		if ( !v_pConfig) {
			return;
		}
		pConfigList_.AddTail(v_pConfig);
	}

private:

	CInterfaceList<ITemplateConfig> pConfigList_;

};

HRESULT __stdcall LoadTemplateConfigCollection(IConfStrageDir* v_pConfStrageDir,
									 ITemplateConfigFactory* v_pFactory,
									 ITemplateConfig* v_pDefaultConfig,
									 ITemplateConfigCollection** v_ppConfigCollection) throw()
{
	if ( !v_pConfStrageDir || !v_pFactory) {
		return E_INVALIDARG;
	}
	if ( !v_ppConfigCollection) {
		return E_POINTER;
	}
	try {
		ATLASSERT(!*v_ppConfigCollection);
		*v_ppConfigCollection = NULL;

		HRESULT hr;

		CComObject<CTemplateConfigCollection>* pCollectionImpl = NULL;
		hr = CComObject<CTemplateConfigCollection>::CreateInstance(&pCollectionImpl);
		if (FAILED(hr)) return hr;
		CComPtr<ITemplateConfigCollection> pCollection(pCollectionImpl);
		ATLASSERT(pCollection);
		
		CComPtr<IConfStrageDirEnumStrages> pEnumStrages;
		hr = v_pConfStrageDir->EnumStrages(&pEnumStrages);
		if (FAILED(hr)) return hr;

		bool occuredError = false;

		CComPtr<IConfStrage> pConfStrage;
		while ((hr = pEnumStrages->Next(NULL, &pConfStrage)) == S_OK) {
			ATLASSERT(pConfStrage);
			CComPtr<ITemplateConfig> pConfig;
			hr = LoadTemplateConfig(pConfStrage, v_pFactory, v_pDefaultConfig, &pConfig);
			if (FAILED(hr)) {
				occuredError = true;
			}
			else {
				ATLASSERT(pConfig);
				CComBSTR name;
				hr = pConfig->GetName(&name);
				if (SUCCEEDED(hr)) {
					// ev[go^Ă΃RNVɒǉ
					pCollectionImpl->Append(pConfig);
				}
			}
			pConfStrage.Release();
		}
		if (FAILED(hr)) return hr;

		hr = pCollection.CopyTo(v_ppConfigCollection);
		if (FAILED(hr)) return hr;

		return occuredError ? S_FALSE : S_OK;
	}
	catch (const CAtlException& exception) {
		return exception.m_hr;
	}
	catch (...) {
		return E_FAIL;
	}
	return S_OK;
}

