#pragma once

#include "resource.h"

#include <atlwin.h>

#include "Setting.h"
#include "HTMLLinkCollector.h"
#include "TemplateConfig.h"

class CSettingDlg :
	public CDialogImpl<CSettingDlg>
{
public:
	enum {IDD = IDD_SETTINGDLG};
	enum {IDC_SYSCMD_ABOUT = IDS_SYSCMD_HELP};

	CSettingDlg(void);
	virtual ~CSettingDlg(void);

	BEGIN_MSG_MAP(CSettingDlg)
		MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
		MESSAGE_HANDLER(WM_HELP, OnHelp)
		MESSAGE_HANDLER(WM_SYSCOMMAND, OnSysCommand)
		COMMAND_ID_HANDLER( IDOK, OnOK )
		COMMAND_ID_HANDLER( IDCANCEL, OnCancel )
		COMMAND_HANDLER(IDC_RESET, BN_CLICKED, OnBnClickedReset)
		COMMAND_HANDLER(IDC_IMG_LINK, BN_CLICKED, OnBnClicked)
		COMMAND_HANDLER(IDC_IMG, BN_CLICKED, OnBnClicked)
		COMMAND_HANDLER(IDC_IMG_SIZE, BN_CLICKED, OnBnClicked)
		COMMAND_HANDLER(IDC_LINK, BN_CLICKED, OnBnClicked)
		COMMAND_HANDLER(IDC_URL_LINK, BN_CLICKED, OnBnClicked)
		COMMAND_HANDLER(IDC_URL, BN_CLICKED, OnBnClicked)
	END_MSG_MAP()

	LRESULT OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);

	LRESULT OnSysCommand(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);

	LRESULT OnHelp(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);

	LRESULT OnOK(
		WORD wNotifyCode,
		WORD wID,
		HWND hWndCtl,
		BOOL& bHandled
		);

	LRESULT OnCancel(
		WORD wNotifyCode,
		WORD wID,
		HWND hWndCtl,
		BOOL& bHandled 
		);

	HRESULT SetSetting(ISetting* v_pSetting) throw();

	HRESULT GetSetting(ISetting** v_ppSetting) throw();

	HRESULT SetURLLimitSuggest(IHTMLLinkCollector* v_pLinkCollector) throw();

	HRESULT GetURLLimitSuggest(IHTMLLinkCollector** v_ppLinkCollector) throw();

	HRESULT SetTemplateConfigCollection(ITemplateConfigCollection* v_pTemplateConfigCollection) throw();

	HRESULT GetTemplateConfigCollection(ITemplateConfigCollection** v_ppTemplateConfigCollection) throw();

	LRESULT OnBnClickedReset(WORD /*wNotifyCode*/,
		WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);

	LRESULT OnBnClicked(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/);

protected:

	void UpdateAllItems(void);

	void UpdateEnable(void);

	CComPtr<ISetting> pSetting_;

	CComPtr<IHTMLLinkCollector> pLinkCollector_;

	CComPtr<ITemplateConfigCollection> pTemplateConfigCollection_;

};
