#include "stdafx.h"
#include "resource.h"

#include "Setting.h"

class __declspec(uuid("{77660F33-A60C-430e-9627-E5CE6D09BB1A}")) CSetting
	: public ISetting
	, public IPersistConf
	, public CComObjectRoot
	, public CComCoClass<CSetting, &__uuidof(CSetting)>
{
public:
	DECLARE_OBJECT_DESCRIPTION("MkImgPage Setting Object")

	BEGIN_COM_MAP(CSetting)
		COM_INTERFACE_ENTRY(ISettingReader)
		COM_INTERFACE_ENTRY(ISetting)
		COM_INTERFACE_ENTRY(IPersistConf)
	END_COM_MAP( )

	DECLARE_CLASSFACTORY()
	DECLARE_NO_REGISTRY()

	DECLARE_PROTECT_FINAL_CONSTRUCT()
	
	HRESULT FinalConstruct() throw()
	{
		return InitNew();
	}

	virtual HRESULT __stdcall InitNew(void) throw()
	{
		try {
			imgLink_ = TRUE;
			imgLinkExt_.LoadString(IDS_INIT_IMG_LINK_EXT);

			img_ = TRUE;
			imgExt_.LoadString(IDS_INIT_IMG_EXT);

			imgSize_ = TRUE;
			imgWidth_ = 200;
			imgHeight_ = 200;

			urlLink_ = TRUE;
			urlLinkExt_.LoadString(IDS_INIT_URL_LINK_EXT);

			frameWidth_ = 600;
			frameHeight_ = 200;

			link_ = TRUE;
			linkExt_.LoadString(IDS_INIT_LINK_EXT);

			url_ = FALSE;
			urlLimit_.Empty();

			openNew_ = FALSE;

			title_.Empty();
			templateName_.Empty();

			dirty_ = FALSE;

			return S_OK;
		}
		catch (const CAtlException& exception) {
			ATLASSERT(false);
			return exception.m_hr;
		}
		catch (...) {
			ATLASSERT(false);
			return E_FAIL;
		}
	}

	virtual HRESULT __stdcall Load(IConfStrage* v_pConfStrage) throw()
	{
		if ( !v_pConfStrage) {
			return E_INVALIDARG;
		}

		try {
			CComBSTR tmp;

			CHK(InitNew());

			CHK(v_pConfStrage->GetInt(L"ImgLink", imgLink_, &imgLink_));
			
			tmp.Empty();
			CHK(v_pConfStrage->GetString(L"ImgLinkExt", imgLinkExt_, &tmp));
			imgLinkExt_ = tmp;

			CHK(v_pConfStrage->GetInt(L"Img", img_, &img_));
			
			tmp.Empty();
			CHK(v_pConfStrage->GetString(L"ImgExt", imgExt_, &tmp));
			imgExt_ = tmp;

			CHK(v_pConfStrage->GetInt(L"ImgSize", imgSize_, &imgSize_));
			CHK(v_pConfStrage->GetInt(L"ImgWidth", imgWidth_, &imgWidth_));
			CHK(v_pConfStrage->GetInt(L"ImgHeight", imgHeight_, &imgHeight_));
			CHK(v_pConfStrage->GetInt(L"UrlLink", urlLink_, &urlLink_));
			
			tmp.Empty();
			CHK(v_pConfStrage->GetString(L"UrlLinkExt", urlLinkExt_, &tmp));
			urlLinkExt_ = tmp;

			CHK(v_pConfStrage->GetInt(L"FrameWidth", frameWidth_, &frameWidth_));
			CHK(v_pConfStrage->GetInt(L"FrameHeight", frameHeight_, &frameHeight_));
			CHK(v_pConfStrage->GetInt(L"Link", link_, &link_));
			
			tmp.Empty();
			CHK(v_pConfStrage->GetString(L"LinkExt", linkExt_, &tmp));
			linkExt_ = tmp;

			CHK(v_pConfStrage->GetInt(L"URL", url_, &url_));

			CHK(v_pConfStrage->GetInt(L"OpenNew", openNew_, &openNew_));

			tmp.Empty();
			CHK(v_pConfStrage->GetString(L"TemplateName", templateName_, &tmp));
			templateName_ = tmp;

			// URLLimitTitle͉iΏۊOB

			dirty_ = FALSE;

			return S_OK;
		}
		catch (const CAtlException& exception) {
			ATLASSERT(false);
			return exception.m_hr;
		}
		catch (...) {
			ATLASSERT(false);
			return E_FAIL;
		}
	}

	virtual HRESULT __stdcall Save(IConfStrage* v_pConfStrage) throw()
	{
		if ( !v_pConfStrage) {
			return E_INVALIDARG;
		}

		try {
			CHK(v_pConfStrage->WriteInt(L"ImgLink", imgLink_));
			CHK(v_pConfStrage->WriteString(L"ImgLinkExt", imgLinkExt_));

			CHK(v_pConfStrage->WriteInt(L"Img", img_));
			CHK(v_pConfStrage->WriteString(L"ImgExt", imgExt_));

			CHK(v_pConfStrage->WriteInt(L"ImgSize", imgSize_));
			CHK(v_pConfStrage->WriteInt(L"ImgWidth", imgWidth_));
			CHK(v_pConfStrage->WriteInt(L"ImgHeight", imgHeight_));

			CHK(v_pConfStrage->WriteInt(L"UrlLink", urlLink_));
			CHK(v_pConfStrage->WriteString(L"UrlLinkExt", urlLinkExt_));

			CHK(v_pConfStrage->WriteInt(L"FrameWidth", frameWidth_));
			CHK(v_pConfStrage->WriteInt(L"FrameHeight", frameHeight_));

			CHK(v_pConfStrage->WriteInt(L"Link", link_));
			CHK(v_pConfStrage->WriteString(L"LinkExt", linkExt_));

			CHK(v_pConfStrage->WriteInt(L"URL", url_));

			CHK(v_pConfStrage->WriteInt(L"OpenNew", openNew_));

			CHK(v_pConfStrage->WriteString(L"TemplateName", templateName_));

			// URLLimitTitle͉iΏۊOB

			dirty_ = FALSE;

			return S_OK;
		}
		catch (const CAtlException& exception) {
			ATLASSERT(false);
			return exception.m_hr;
		}
		catch (...) {
			ATLASSERT(false);
			return E_FAIL;
		}
	}

	virtual HRESULT __stdcall IsDirty(void) throw()
	{
		return dirty_ ? S_OK: S_FALSE;
	}

	//

	/**
	 * 摜ւ̃NIMGɕϊ܂
	 */
	virtual HRESULT __stdcall put_ImgLink(BOOL v_value) throw()
	{
		imgLink_ = v_value ? TRUE : FALSE;
		dirty_ = TRUE;
		return S_OK;
	}

	/**
	 * 摜ւ̃NIMGɕϊ܂B
	 */
	virtual HRESULT __stdcall is_ImgLink(void) throw()
	{
		return imgLink_ ? S_OK : S_FALSE;
	}

	/**
	 * 摜ւ̃NIMGɕϊtB^
	 */
	virtual HRESULT __stdcall put_ImgLink_Ext(LPCWSTR v_value) throw()
	{
		if ( !v_value) {
			v_value = L"";
		}
		try {
			imgLinkExt_ = v_value;
			dirty_ = TRUE;
			return S_OK;
		}
		catch (...) {
			ATLASSERT(false);
			return E_FAIL;
		}
	}

	/**
	 * 摜ւ̃NIMGɕϊtB^
	 */
	virtual HRESULT __stdcall get_ImgLink_Ext(BSTR* v_pValue) throw()
	{
		return imgLinkExt_.CopyTo(v_pValue);
	}

	/**
	 * 摜IMGɕϊ܂B
	 */
	virtual HRESULT __stdcall put_Img(BOOL v_value) throw()
	{
		img_ = v_value ? TRUE : FALSE;
		dirty_ = TRUE;
		return S_OK;
	}

	/**
	 * 摜IMGɕϊ܂B
	 */
	virtual HRESULT __stdcall is_Img(void) throw()
	{
		return img_ ? S_OK : S_FALSE;
	}

	/**
	 * 摜IMGɕϊtB^B
	 */
	virtual HRESULT __stdcall put_Img_Ext(LPCWSTR v_value) throw()
	{
		if ( !v_value) {
			v_value = L"";
		}
		try {
			imgExt_ = v_value;
			dirty_ = TRUE;
			return S_OK;
		}
		catch (...) {
			ATLASSERT(false);
			return E_FAIL;
		}
	}

	/**
	 * 摜IMGɕϊtB^B
	 */
	virtual HRESULT __stdcall get_Img_Ext(BSTR* v_pValue) throw()
	{
		return imgExt_.CopyTo(v_pValue);
	}

	/**
	 * 摜IMGɕϊTCY
	 */
	virtual HRESULT __stdcall put_Img_Size(BOOL v_value) throw()
	{
		imgSize_ = v_value ? TRUE : FALSE;
		dirty_ = TRUE;
		return S_OK;
	}

	/**
	 * 摜IMGɕϊTCY
	 */
	virtual HRESULT __stdcall is_Img_Size(void) throw()
	{
		return imgSize_ ? S_OK : S_FALSE;
	}

	/**
	 * 摜IMGɕϊTCY()
	 */
	virtual HRESULT __stdcall put_Img_Width(UINT v_value) throw()
	{
		imgWidth_ = v_value;
		dirty_ = TRUE;
		return S_OK;
	}

	/**
	 * 摜IMGɕϊTCY()
	 */
	virtual HRESULT __stdcall get_Img_Width(UINT* v_pValue) throw()
	{
		if ( !v_pValue) {
			return E_POINTER;
		}
		*v_pValue = imgWidth_;
		return S_OK;
	}

	/**
	 * 摜IMGɕϊTCY()
	 */
	virtual HRESULT __stdcall put_Img_Height(UINT v_value) throw()
	{
		imgHeight_ = v_value;
		dirty_ = TRUE;
		return S_OK;
	}

	/**
	 * 摜IMGɕϊTCY()
	 */
	virtual HRESULT __stdcall get_Img_Height(UINT* v_pValue) throw()
	{
		if ( !v_pValue) {
			return E_POINTER;
		}
		*v_pValue = imgHeight_;
		return S_OK;
	}

	/**
	 * URLIMGɕϊTCY
	 */
	virtual HRESULT __stdcall put_URLLink(BOOL v_value) throw()
	{
		urlLink_ = v_value ? TRUE : FALSE;
		dirty_ = TRUE;
		return S_OK;
	}

	/**
	 * URLIFRAMEɕϊ܂B
	 */
	virtual HRESULT __stdcall is_URLLink(void) throw()
	{
		return urlLink_ ? S_OK : S_FALSE;
	}

	/**
	 * URLIFRAMEɕϊtB^B
	 */
	virtual HRESULT __stdcall put_URLLink_Ext(LPCWSTR v_value) throw()
	{
		if ( !v_value) {
			v_value = L"";
		}
		try {
			urlLinkExt_ = v_value;
			dirty_ = TRUE;
			return S_OK;
		}
		catch (...) {
			ATLASSERT(false);
			return E_FAIL;
		}
	}

	/**
	 * URLIFRAMEɕϊtB^B
	 */
	virtual HRESULT __stdcall get_URLLink_Ext(BSTR* v_pValue) throw()
	{
		return urlLinkExt_.CopyTo(v_pValue);
	}

	/**
	 * IFRAME()
	 */
	virtual HRESULT __stdcall put_IFrame_Width(UINT v_value) throw()
	{
		frameWidth_ = v_value;
		dirty_ = TRUE;
		return S_OK;
	}

	/**
	 * IFRAME()
	 */
	virtual HRESULT __stdcall get_IFrame_Width(UINT* v_pValue) throw()
	{
		if ( !v_pValue) {
			return E_POINTER;
		}
		*v_pValue = frameWidth_;
		return S_OK;
	}

	/**
	 * IFRAME()
	 */
	virtual HRESULT __stdcall put_IFrame_Height(UINT v_value) throw()
	{
		frameHeight_ = v_value;
		dirty_ = TRUE;
		return S_OK;
	}

	/**
	 * IFRAME()
	 */
	virtual HRESULT __stdcall get_IFrame_Height(UINT* v_pValue) throw()
	{
		if ( !v_pValue) {
			return E_POINTER;
		}
		*v_pValue = frameHeight_;
		return S_OK;
	}

	/**
	 * URLLINKɕϊ
	 */
	virtual HRESULT __stdcall put_Link(BOOL v_value) throw()
	{
		link_ = v_value ? TRUE : FALSE;
		dirty_ = TRUE;
		return S_OK;
	}

	/**
	 * URLLINKɕϊ
	 */
	virtual HRESULT __stdcall is_Link(void) throw()
	{
		return link_ ? S_OK : S_FALSE;
	}

	/**
	 * URLLINKɕϊtB^B
	 */
	virtual HRESULT __stdcall put_Link_Ext(LPCWSTR v_value) throw()
	{
		if ( !v_value) {
			v_value = L"";
		}
		try {
			linkExt_ = v_value;
			dirty_ = TRUE;
			return S_OK;
		}
		catch (...) {
			ATLASSERT(false);
			return E_FAIL;
		}
	}

	/**
	 * URLLINKɕϊtB^B
	 */
	virtual HRESULT __stdcall get_Link_Ext(BSTR* v_pValue) throw()
	{
		return linkExt_.CopyTo(v_pValue);
	}

	/**
	 * URL̐
	 */
	virtual HRESULT __stdcall put_URL(BOOL v_value) throw()
	{
		url_ = v_value ? TRUE : FALSE;
		dirty_ = TRUE;
		return S_OK;
	}

	/**
	 * URL̐
	 */
	virtual HRESULT __stdcall is_URL(void) throw()
	{
		return url_ ? S_OK : S_FALSE;
	}

	/**
	 * URL̐tB^
	 */
	virtual HRESULT __stdcall put_URL_Limit(LPCWSTR v_value) throw()
	{
		if ( !v_value) {
			v_value = L"";
		}
		try {
			urlLimit_ = v_value;
			// dirty_ = TRUE; /// iΏۊOɂAsv
			return S_OK;
		}
		catch (...) {
			ATLASSERT(false);
			return E_FAIL;
		}
	}

	/**
	 * URL̐tB^
	 */
	virtual HRESULT __stdcall get_URL_Limit(BSTR* v_pValue) throw()
	{
		return urlLimit_.CopyTo(v_pValue);
	}

	/**
	 * VEBhEJ
	 */
	virtual HRESULT __stdcall put_OpenNewWindow(BOOL v_value) throw()
	{
		openNew_ = v_value ? TRUE : FALSE;
		dirty_ = TRUE;
		return S_OK;
	}

	/**
	 * VEBhEJ
	 */
	virtual HRESULT __stdcall is_OpenNewWindow(void) throw()
	{
		return openNew_ ? S_OK : S_FALSE;
	}

	/**
	 * ^Cg
	 */
	virtual HRESULT __stdcall get_Title(BSTR* v_pTitle) throw()
	{
		return title_.CopyTo(v_pTitle);
	}

	/**
	 * ^Cg
	 */
	virtual HRESULT __stdcall put_Title(LPCWSTR v_pTitle) throw()
	{
		if ( !v_pTitle) {
			v_pTitle = L"";
		}
		try {
			title_ = v_pTitle;
		}
		catch (...) {
			ATLASSERT(false);
			return E_FAIL;
		}
		return S_OK;
	}

	/**
	 * ev[g
	 */
	virtual HRESULT __stdcall get_TemplateName(BSTR* v_pTemplateName) throw()
	{
		return templateName_.CopyTo(v_pTemplateName);
	}

	/**
	 * ev[g
	 */
	virtual HRESULT __stdcall put_TemplateName(LPCWSTR v_pTemplateName) throw()
	{
		if ( !v_pTemplateName) {
			v_pTemplateName = L"";
		}
		try {
			templateName_ = v_pTemplateName;
		}
		catch (...) {
			ATLASSERT(false);
			return E_FAIL;
		}
		return S_OK;
	}

	/**
	 * XNvgIuWFNgɐݒlށB
	 */
	virtual HRESULT __stdcall SetToScriptObject(IScriptObject* v_pScriptObject) throw()
	{
		if ( !v_pScriptObject) {
			return E_INVALIDARG;
		}

		try {
			HRESULT hr;

			CComVariant varImgLink(imgLink_ ? true : false);
			hr = v_pScriptObject->put_item(CComVariant(L"imglink"), varImgLink);
			if (FAILED(hr)) return hr;

			CComVariant varImgLinkExt;
			if (imgLinkExt_) {
				varImgLinkExt = imgLinkExt_;
			}
			hr = v_pScriptObject->put_item(CComVariant(L"imglinkExt"), varImgLinkExt);
			if (FAILED(hr)) return hr;

			CComVariant varImg(img_ ? true : false);
			hr = v_pScriptObject->put_item(CComVariant(L"img"), varImg);
			if (FAILED(hr)) return hr;

			CComVariant varImgExt;
			if (imgExt_) {
				varImgExt = imgExt_;
			}
			hr = v_pScriptObject->put_item(CComVariant(L"imgExt"), varImgExt);
			if (FAILED(hr)) return hr;

			CComVariant varImgSize(imgSize_ ? true : false);
			hr = v_pScriptObject->put_item(CComVariant(L"imgSize"), varImgSize);
			if (FAILED(hr)) return hr;

			CComVariant varImgWidth(imgWidth_);
			hr = v_pScriptObject->put_item(CComVariant(L"imgWidth"), varImgWidth);
			if (FAILED(hr)) return hr;

			CComVariant varImgHeight(imgHeight_);
			hr = v_pScriptObject->put_item(CComVariant(L"imgHeight"), varImgHeight);
			if (FAILED(hr)) return hr;

			CComVariant varIFrame(urlLink_ ? true : false);
			hr = v_pScriptObject->put_item(CComVariant(L"iframe"), varIFrame);
			if (FAILED(hr)) return hr;

			CComVariant varIFrameExt;
			if (urlLinkExt_) {
				varIFrameExt = urlLinkExt_;
			}
			hr = v_pScriptObject->put_item(CComVariant(L"iframeExt"), varIFrameExt);
			if (FAILED(hr)) return hr;

			CComVariant varIFrameWidth(frameWidth_);
			hr = v_pScriptObject->put_item(CComVariant(L"iframeWidth"), varIFrameWidth);
			if (FAILED(hr)) return hr;

			CComVariant varIFrameHeight(frameHeight_);
			hr = v_pScriptObject->put_item(CComVariant(L"iframeHeight"), varIFrameHeight);
			if (FAILED(hr)) return hr;

			CComVariant varAnchor(link_ ? true : false);
			hr = v_pScriptObject->put_item(CComVariant(L"anchor"), varAnchor);
			if (FAILED(hr)) return hr;

			CComVariant varAnchorExt(linkExt_);
			hr = v_pScriptObject->put_item(CComVariant(L"anchorExt"), varAnchorExt);
			if (FAILED(hr)) return hr;

			CComVariant varURLLimit(url_ ? true : false);
			hr = v_pScriptObject->put_item(CComVariant(L"URLLimit"), varURLLimit);
			if (FAILED(hr)) return hr;

			CComVariant varURLLimitPrefix;
			if (urlLimit_) {
				varURLLimitPrefix = urlLimit_;
			}
			hr = v_pScriptObject->put_item(CComVariant(L"URLLimitPrefix"), varURLLimitPrefix);
			if (FAILED(hr)) return hr;

			CComVariant varOpenNew(openNew_ ? true : false);
			hr = v_pScriptObject->put_item(CComVariant(L"openNew"), varOpenNew);
			if (FAILED(hr)) return hr;

			CComVariant varTitle;
			if (title_) {
				varTitle = title_;
			}
			hr = v_pScriptObject->put_item(CComVariant(L"title"), varTitle);
			if (FAILED(hr)) return hr;

			CComVariant varTemplateName;
			if (templateName_) {
				varTemplateName = templateName_;
			}
			hr = v_pScriptObject->put_item(CComVariant(L"templateName"), varTemplateName);
			if (FAILED(hr)) return hr;

			return S_OK;
		}
		catch (const CAtlException& exception) {
			ATLASSERT(false);
			return exception.m_hr;
		}
		catch (...) {
			ATLASSERT(false);
			return E_FAIL;
		}
	}

protected:

	static inline void CHK(HRESULT hr)
	{
		if (FAILED(hr)) {
			AtlThrow(hr);
		}
	}

	BOOL dirty_;

	int imgLink_;
	CComBSTR imgLinkExt_;

	int img_;
	CComBSTR imgExt_;

	int imgSize_;
	int imgWidth_;
	int imgHeight_;

	int urlLink_;
	CComBSTR urlLinkExt_;

	int frameWidth_;
	int frameHeight_;

	int link_;
	CComBSTR linkExt_;

	int url_;
	CComBSTR urlLimit_;

	int openNew_;

	CComBSTR title_;

	CComBSTR templateName_;
};

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CSetting), CSetting);


HRESULT __stdcall CreateSetting(ISetting** v_ppSetting) throw()
{
	if ( !v_ppSetting) {
		return E_POINTER;
	}
	return CSetting::CreateInstance(v_ppSetting);
}


///

class __declspec(uuid("{D376DC12-4329-498b-AA2E-383E70E306F2}")) CSettingAcceptors
	: public ISettingAcceptors
	, public CComObjectRoot
{
public:
	BEGIN_COM_MAP(CSettingAcceptors)
		COM_INTERFACE_ENTRY(ISettingReader)
		COM_INTERFACE_ENTRY(ISettingAcceptors)
	END_COM_MAP( )

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT Init(ISettingReader* v_pSetting) throw()
	{
		if ( !v_pSetting) {
			return E_INVALIDARG;
		}

		try {
			HRESULT hr;

			pSetting_ = v_pSetting;

			// Op^[𔻒肷AZNv^̃t@Ng\z܂B
			CComPtr<ISingleArgNameAcceptorFactory> pPatternNameAcceptorFactory;
			hr = CreatePatternNameAcceptorFactory(&pPatternNameAcceptorFactory);
			if (FAILED(hr)) {
				return hr;
			}

			// URL̐sv𔻒肷ANZv^\z܂B
			CComBSTR prefix;
			CComPtr<INameAcceptor> pURLPrefixAcceptor;
			hr = pSetting_->is_URL();
			if (FAILED(hr)) {
				return hr;
			}
			if (hr == S_OK) {
				hr = pSetting_->get_URL_Limit(&prefix);
				if (FAILED(hr)) {
					return hr;
				}
				HRESULT hasWildCard = IsIncludedWildCard(prefix);
				if (FAILED(hasWildCard)) {
					return hasWildCard;
				}
				if (hasWildCard == S_OK) {
					// URLsvɃChJ[h܂܂Ăꍇ
					hr = pPatternNameAcceptorFactory->CreateSingleArgNameAcceptor(prefix, &pURLPrefixAcceptor);
				}
				else {
					hr = CreateSimpleNameAcceptor(prefix, &pURLPrefixAcceptor);
				}
				if (FAILED(hr)) {
					return hr;
				}
			}

			// URLmailtoXL[}ł΃WFNglKeBuANZv^\z܂B
			CComPtr<INameAcceptor> pMailtoSchemaRejector;
			CComPtr<INameAcceptor> pMailtoSchemaAcceptor;
			hr = CreateSimpleNameAcceptor(L"mailto:", &pMailtoSchemaAcceptor);
			if (FAILED(hr)) {
				return hr;
			}
			hr = CreateNegativeNameAcceptor(pMailtoSchemaAcceptor, &pMailtoSchemaRejector);
			if (FAILED(hr)) {
				return hr;
			}

			// gq擾ISettingReader̊֐
			// ANZv^IuWFNgɂĊi[`
			const FilterPair filters[] = {
				{&ISettingReader::get_ImgLink_Ext, &pImgLinkAcceptor_},
				{&ISettingReader::get_Img_Ext, &pImgAcceptor_},
				{&ISettingReader::get_URLLink_Ext, &pURLLinkAcceptor_},
				{&ISettingReader::get_Link_Ext, &pLinkAcceptor_},
				{NULL, NULL}
			};

			// ̊gq[vŏ
			for (const FilterPair* p = filters; p->pGetter != NULL; ++p) {
				// `F[ANZv^̍쐬
				CComPtr<IMultiNameAcceptor> pMultiAcceptor;
				hr = CreateMultiNameAcceptor(TRUE, &pMultiAcceptor);
				if (FAILED(hr)) {
					return hr;
				}

				// mailtoWFN^̓o^
				hr = pMultiAcceptor->Add(pMailtoSchemaRejector);
				if (FAILED(hr)) {
					return hr;
				}

				// URL~bg̃`FCւ̓o^
				if (pURLPrefixAcceptor) {
					hr = pMultiAcceptor->Add(pURLPrefixAcceptor);
					if (FAILED(hr)) {
						return hr;
					}
				}

				// gq̎擾
				CComBSTR exts;
				hr = (pSetting_->*(p->pGetter))(&exts);
				if (FAILED(hr)) {
					return hr;
				}
				if (exts && exts.Length() > 0) {
					// }`ANZv^쐬
					CComPtr<IMultiNameAcceptor> pMultiExtAcceptor;
					hr = CreateMultiNameAcceptor(FALSE, &pMultiExtAcceptor);
					if (FAILED(hr)) {
						return hr;
					}
					// gqXg疼O}b`OANv^쐬}`ANZv^ɓo^
					hr = ConfigureMultiPatternNameAcceptor(exts, pPatternNameAcceptorFactory, pMultiExtAcceptor);
					if (FAILED(hr)) {
						return hr;
					}

					// OANZv^A_v^̓o^
					hr = pMultiAcceptor->Add(pMultiExtAcceptor);
					if (FAILED(hr)) {
						return hr;
					}
				}
				
				// tB^oϐɓo^
				ATLASSERT( !*(p->ppFilter));
				hr = pMultiAcceptor.QueryInterface(p->ppFilter);
				if (FAILED(hr)) {
					return hr;
				}
			}
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	/**
	 * 摜ւ̃NIMGɕϊ܂B
	 */
	virtual HRESULT __stdcall is_ImgLink(void) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->is_ImgLink();
	}

	/**
	 * 摜ւ̃NIMGɕϊtB^
	 */
	virtual HRESULT __stdcall get_ImgLink_Ext(BSTR* v_pValue) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->get_ImgLink_Ext(v_pValue);
	}

	/**
	 * 摜IMGɕϊ܂B
	 */
	virtual HRESULT __stdcall is_Img(void) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->is_Img();
	}

	/**
	 * 摜IMGɕϊtB^B
	 */
	virtual HRESULT __stdcall get_Img_Ext(BSTR* v_pValue) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->get_Img_Ext(v_pValue);
	}

	/**
	 * 摜IMGɕϊTCY
	 */
	virtual HRESULT __stdcall is_Img_Size(void) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->is_Img_Size();
	}

	/**
	 * 摜IMGɕϊTCY()
	 */
	virtual HRESULT __stdcall get_Img_Width(UINT* v_pValue) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->get_Img_Width(v_pValue);
	}

	/**
	 * 摜IMGɕϊTCY()
	 */
	virtual HRESULT __stdcall get_Img_Height(UINT* v_pValue) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->get_Img_Height(v_pValue);
	}

	/**
	 * URLIMGɕϊTCY
	 */
	virtual HRESULT __stdcall is_URLLink(void) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->is_URLLink();
	}

	/**
	 * URLIMGɕϊtB^B
	 */
	virtual HRESULT __stdcall get_URLLink_Ext(BSTR* v_pValue) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->get_URLLink_Ext(v_pValue);
	}

	/**
	 * IFRAME()
	 */
	virtual HRESULT __stdcall get_IFrame_Width(UINT* v_pValue) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->get_IFrame_Width(v_pValue);
	}

	/**
	 * IFRAME()
	 */
	virtual HRESULT __stdcall get_IFrame_Height(UINT* v_pValue) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->get_IFrame_Height(v_pValue);
	}

	/**
	 * URLLINKɕϊ
	 */
	virtual HRESULT __stdcall is_Link(void) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->is_Link();
	}

	/**
	 * URLLINKɕϊtB^B
	 */
	virtual HRESULT __stdcall get_Link_Ext(BSTR* v_pValue) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->get_Link_Ext(v_pValue);
	}

	/**
	 * URL̐
	 */
	virtual HRESULT __stdcall is_URL(void) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->is_URL();
	}

	/**
	 * URL̐tB^
	 */
	virtual HRESULT __stdcall get_URL_Limit(BSTR* v_pValue) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->get_URL_Limit(v_pValue);
	}

	/**
	 * VEBhEJ
	 */
	virtual HRESULT __stdcall is_OpenNewWindow(void) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->is_OpenNewWindow();
	}

	/**
	 * ^Cg
	 */
	virtual HRESULT __stdcall get_Title(BSTR* v_pTitle) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->get_Title(v_pTitle);
	}

	virtual HRESULT __stdcall get_TemplateName(BSTR* v_pTemplateName) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->get_TemplateName(v_pTemplateName);
	}

	/**
	 * XNvgIuWFNgɐݒl
	 */
	virtual HRESULT __stdcall SetToScriptObject(IScriptObject* v_pScriptObject) throw()
	{
		ATLASSERT(pSetting_);
		return pSetting_->SetToScriptObject(v_pScriptObject);
	}

	///

	virtual HRESULT __stdcall IsAcceptable_ImgLink(LPCWSTR v_url) throw()
	{
		ATLASSERT(pImgLinkAcceptor_);
		return pImgLinkAcceptor_->IsAcceptable(v_url);
	}

	virtual HRESULT __stdcall IsAcceptable_Img(LPCWSTR v_url) throw()
	{
		ATLASSERT(pImgAcceptor_);
		return pImgAcceptor_->IsAcceptable(v_url);
	}

	virtual HRESULT __stdcall IsAcceptable_URLLink(LPCWSTR v_url) throw()
	{
		ATLASSERT(pURLLinkAcceptor_);
		return pURLLinkAcceptor_->IsAcceptable(v_url);
	}

	virtual HRESULT __stdcall IsAcceptable_Link(LPCWSTR v_url) throw()
	{
		ATLASSERT(pLinkAcceptor_);
		return pLinkAcceptor_->IsAcceptable(v_url);
	}

protected:

	CComPtr<ISettingReader> pSetting_;

	CComPtr<INameAcceptor> pURLLinkAcceptor_;
	CComPtr<INameAcceptor> pImgLinkAcceptor_;
	CComPtr<INameAcceptor> pImgAcceptor_;
	CComPtr<INameAcceptor> pLinkAcceptor_;

	typedef HRESULT (__stdcall ISettingReader::*ExtGetterFuncPtr)(BSTR*);
	
	struct FilterPair {
		ExtGetterFuncPtr pGetter;
		INameAcceptor** ppFilter;
	};
};

HRESULT __stdcall CreateSettingAcceptors(ISettingReader* v_pSetting, ISettingAcceptors** v_ppSettingAcceptors) throw()
{
	if ( !v_pSetting) {
		return E_INVALIDARG;
	}
	if ( !v_ppSettingAcceptors) {
		return E_POINTER;
	}

	HRESULT hr;
	CComObject<CSettingAcceptors>* pSettingAcceptorsImpl = NULL;
	hr = CComObject<CSettingAcceptors>::CreateInstance(&pSettingAcceptorsImpl);
	if (FAILED(hr)) {
		return hr;
	}
	CComPtr<ISettingAcceptors> pSettingAcceptors(pSettingAcceptorsImpl);

	hr = pSettingAcceptorsImpl->Init(v_pSetting);
	if (FAILED(hr)) {
		return hr;
	}

	return pSettingAcceptors.CopyTo(v_ppSettingAcceptors);
}

