#include "stdafx.h"

#include <Exdisp.h>

#include "HTMLElementFilter.h"

class __declspec(uuid("{876668A5-FEEC-4d8e-B3B1-52946EBF1AA3}")) CHTMLElementFilter
	: public IHTMLElementFilter
	, public CComObjectRoot
	, public CComCoClass<CHTMLElementFilter, &__uuidof(CHTMLElementFilter)>
{
public:
	DECLARE_OBJECT_DESCRIPTION("MkImgPage HTMLElementFilter Object")

	BEGIN_COM_MAP(CHTMLElementFilter)
		COM_INTERFACE_ENTRY(IHTMLElementFilter)
	END_COM_MAP( )

	DECLARE_CLASSFACTORY()
	DECLARE_NO_REGISTRY()

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct() throw()
	{
		return Reset();
	}

	void FinalRelease() throw()
	{
		pScriptObject_.Release();
	}

	virtual HRESULT __stdcall Reset() throw()
	{
		try {
			HRESULT hr;
			CComPtr<IScriptObject> pScriptObject;
			hr = CreateScriptObject(&pScriptObject);
			if (FAILED(hr)) {
				return hr;
			}

			LPCWSTR ppNames[] = {L"img", L"iframe", L"anchor", NULL};
			LPCWSTR* ppName = &ppNames[0];
			while (*ppName) {
				CComPtr<IScriptObject> pSubCollection;
				hr = CreateScriptObject(&pSubCollection);
				if (FAILED(hr)) {
					return hr;
				}
				CComVariant varName(*ppName);
				CComVariant varCollection(pSubCollection);
				hr = pScriptObject->put_item(varName, varCollection);
				if (FAILED(hr)) {
					return hr;
				}
				++ppName;
			}

			pScriptObject_ = pScriptObject;
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	virtual HRESULT __stdcall GetCollection(IScriptObject** v_ppScriptObject) throw()
	{
		return pScriptObject_.CopyTo(v_ppScriptObject);
	}

	virtual HRESULT __stdcall put_Setting(ISettingAcceptors* v_pSetting) throw()
	{
		try {
			pSetting_ = v_pSetting;
		}
		catch (...) {
			return E_FAIL;
		}
		return S_OK;
	}

	virtual HRESULT __stdcall get_Setting(ISettingAcceptors** v_ppSetting) throw()
	{
		return pSetting_.CopyTo(v_ppSetting);
	}

	virtual HRESULT __stdcall DoFilter(IHTMLDocument2* v_pDoc) throw()
	{
		if ( !v_pDoc) {
			return E_INVALIDARG;
		}
		if ( !pSetting_) {
			ATLASSERT(false);
			return E_FAIL;
		}
		ATLASSERT(pScriptObject_);

		bool foundTarget = false;
		HRESULT hr;

		try {
			// ̃hLg̏
			hr = ParseDocument(v_pDoc);
			if (FAILED(hr)) {
				return hr;
			}
			if (hr == S_OK) {
				foundTarget = true;
			}

			// qt[̏

			// ̃Rei̒ɂqRei񋓂
			CComQIPtr<IOleContainer> pItems(v_pDoc);
			CComQIPtr<IEnumUnknown> pItemEnum;
			hr = pItems->EnumObjects(OLECONTF_EMBEDDINGS, &pItemEnum);
			if (FAILED(hr)) {
				return hr;
			}

			for (;;) {
				CComPtr<IUnknown> pItem;
				hr = pItemEnum->Next(1, &pItem, NULL);
				if (FAILED(hr)) {
					return hr;
				}
				if (hr != S_OK) {
					break;
				}

				// 擾qReiqt[łꍇ
				// qt[ȊO͖B
				CComPtr<IWebBrowser2> pFrame;
				hr = pItem.QueryInterface(&pFrame);
				if (SUCCEEDED(hr)) {
					CComPtr<IDispatch> pDocDisp;
					hr = pFrame->get_Document(&pDocDisp);
					if (SUCCEEDED(hr)) {
						// HTMLhLgƂĎ擾łt[݈̂
						CComQIPtr<IHTMLDocument2> pDoc(pDocDisp);
						ATLASSERT(pDoc);

						// qt[hLg̍ċAI
						hr = DoFilter(pDoc);
						if (FAILED(hr)) {
							return hr;
						}
						if (hr == S_OK) {
							foundTarget = true;
						}
					}
				}
			}
		}
		catch (const CAtlException& e) {
			return e.m_hr;
		}
		catch (...) {
			return E_FAIL;
		}

		return foundTarget ? S_OK : S_FALSE;
	}

protected:

	/**
	 * ׂĂ̗vf𑀍삵ăhLg
	 * @param v_pDoc hLg
	 * @return ^[QbgS_OKAȂS_FALSEBsȂG[R[h
	 */
	HRESULT ParseDocument(IHTMLDocument2* v_pDoc)
	{
		if ( !pSetting_) {
			ATLASSERT(FALSE);
			return E_FAIL;
		}
		if ( !v_pDoc) {
			ATLASSERT(FALSE);
			return E_POINTER;
		}

		HRESULT hr;

		// ׂĂ̗vf̎擾
		CComPtr<IHTMLElementCollection> pAll;
		hr = v_pDoc->get_all(&pAll);
		if (FAILED(hr)) {
			return hr;
		}
		
		long length;
		hr = pAll->get_length(&length);
		if (FAILED(hr)) {
			return hr;
		}

		bool foundTarget = false;

		// ׂĂ̗vf̑
		for (long idx = 0; idx < length; idx++) {
			CComVariant varIdx(idx);
			CComVariant empty;
			
			CComPtr<IDispatch> pItemDisp;
			hr = pAll->item(varIdx, empty,&pItemDisp);
			if (FAILED(hr)) {
				return hr;
			}

			// N̎擾
			hr = AnchorElement(pItemDisp);
			if (FAILED(hr)) {
				return hr;
			}
			if (hr == S_OK) {
				foundTarget = true;
				continue;
			}

			// C[W̎擾
			hr = ImageElement(pItemDisp);
			if (FAILED(hr)) {
				return hr;
			}
			if (hr == S_OK) {
				foundTarget = true;
				continue;
			}
		}

		return foundTarget ? S_OK : S_FALSE;
	}

	/**
	 * AJ[Gghref͂URL擾܂B
	 * AJ[AgłȂΉS_FALSEԂ܂B
	 * @param v_pItemDisp Gg
	 * @return ΏۂS_OKAΏۂȂS_FALSEBG[Ȃ΃G[R[h
	 */
	HRESULT AnchorElement(IDispatch* v_pItemDisp)
	{
		ATLASSERT(v_pItemDisp);

		HRESULT hr;
		CComPtr<IHTMLAnchorElement> pAnchor;
		hr = v_pItemDisp->QueryInterface(__uuidof(IHTMLAnchorElement), (void**) &pAnchor);
		if (FAILED(hr)) {
			// AJ[ł͂Ȃ
			return S_FALSE;
		}

		const bool bImgLink = (pSetting_->is_ImgLink() == S_OK);
		const bool bHtmlLink = (pSetting_->is_Link() == S_OK);
		const bool bFrameLink = (pSetting_->is_URLLink() == S_OK);
		
		if ( !bImgLink && !bHtmlLink && !bFrameLink) {
			// wȂ
			return S_FALSE;
		}

		// imgi[pRNV
		CComQIPtr<IScriptObject> pImgLink;
		CComVariant varImgLink;
		hr = pScriptObject_->get_item(CComVariant(L"img"), &varImgLink);
		if (FAILED(hr)) {
			ATLASSERT(false);
			return hr;
		}
		pImgLink = varImgLink.punkVal;
		ATLASSERT(pImgLink);

		// anchori[pRNV
		CComQIPtr<IScriptObject> pHtmlLink;
		CComVariant varHtmlLink;
		hr = pScriptObject_->get_item(CComVariant(L"anchor"), &varHtmlLink);
		if (FAILED(hr)) {
			ATLASSERT(false);
			return hr;
		}
		pHtmlLink = varHtmlLink.punkVal;
		ATLASSERT(pHtmlLink);

		// iframei[pRNV
		CComQIPtr<IScriptObject> pFrameLink;
		CComVariant varFrameLink;
		hr = pScriptObject_->get_item(CComVariant(L"iframe"), &varFrameLink);
		if (FAILED(hr)) {
			ATLASSERT(false);
			return hr;
		}
		pFrameLink = varFrameLink.punkVal;
		ATLASSERT(pFrameLink);

		// URL̎擾
		CComBSTR url;
		hr = pAnchor->get_href(&url);
		if (FAILED(hr)) {
			return hr;
		}
		if ( !url || url.Length() == 0) {
			// NȂ
			return S_FALSE;
		}

		bool foundTarget = false;

		// 摜ւ̃N
		if (bImgLink) {
			hr = pSetting_->IsAcceptable_ImgLink(url);
			if (FAILED(hr)) {
				return hr;
			}
			if(hr == S_OK) {
				CComVariant varUrl(url);
				hr = pImgLink->put_item(varUrl, varUrl);
				if (FAILED(hr)) {
					return hr;
				}
				foundTarget = true;
			}
		}

		// HTMLւ̃N (ANCHOR)
		if (bHtmlLink) {
			hr = pSetting_->IsAcceptable_Link(url);
			if (FAILED(hr)) {
				return hr;
			}
			if (hr == S_OK) {
				CComVariant varUrl(url);
				hr = pHtmlLink->put_item(varUrl, varUrl);
				if (FAILED(hr)) {
					return hr;
				}
				foundTarget = true;
			}
		}

		// HTMLւ̃N (IFRAME)
		if (bFrameLink) {
			hr = pSetting_->IsAcceptable_URLLink(url);
			if (FAILED(hr)) {
				return hr;
			}
			if (hr == S_OK) {
				CComVariant varUrl(url);
				hr = pFrameLink->put_item(varUrl, varUrl);
				if (FAILED(hr)) {
					return hr;
				}
				foundTarget = true;
			}
		}

		return foundTarget ?  S_OK : S_FALSE;
	}

	/**
	 * C[WGgsrc͂AURL擾܂B
	 * C[WGgłȂΉS_FALSEԂ܂B
	 * @param v_pItemDisp Gg
	 * @return ΏۂS_OKAΏۂȂS_FALSEBG[Ȃ΃G[R[h
	 */
	HRESULT ImageElement(IDispatch* v_pItemDisp)
	{
		ATLASSERT(v_pItemDisp);

		// 摜荞ݔ

		HRESULT hr;
		CComPtr<IHTMLImgElement> pImg;
		hr = v_pItemDisp->QueryInterface(__uuidof(IHTMLImgElement), (void**) &pImg);
		if (FAILED(hr)) {
			// 摜ł͂Ȃ
			return S_FALSE;
		}

		if (pSetting_->is_Img() != S_OK) {
			// wȂ
			return S_FALSE;
		}

		// imgi[pRNV
		CComQIPtr<IScriptObject> pImgUrl;
		CComVariant varImgUrl;
		hr = pScriptObject_->get_item(CComVariant(L"img"), &varImgUrl);
		if (FAILED(hr)) {
			ATLASSERT(false);
			return hr;
		}
		pImgUrl = varImgUrl.punkVal;
		ATLASSERT(pImgUrl);


		// 摜URL擾
		CComBSTR url;
		hr = pImg->get_src(&url);
		if (FAILED(hr)) {
			return hr;
		}
		if ( !url || url.Length() == 0) {
			// NȂ
			return S_FALSE;
		}

		// Ώۂ肷
		hr = pSetting_->IsAcceptable_Img(url);
		if (FAILED(hr)) {
			return hr;
		}
		if (hr != S_OK) {
			// ΏۊOURL
			return S_FALSE;
		}

		// 摜TCY
		if (pSetting_->is_Img_Size() == S_OK) {
			// 摜̕\TCY̎擾
			long width = 0;
			long height = 0;
			pImg->get_width(&width);
			pImg->get_height(&height);

			if (width <= 0 || height <= 0) {
				// TCYȂ
				return S_FALSE;
			}

			// 摜TCY
			UINT widthUnderLimit;
			UINT heightUnderLimit;
			hr = pSetting_->get_Img_Width(&widthUnderLimit);
			if (FAILED(hr)) {
				return hr;
			}
			hr = pSetting_->get_Img_Height(&heightUnderLimit);
			if (FAILED(hr)) {
				return hr;
			}

			if (width < (long) widthUnderLimit ||
				height < (long) heightUnderLimit) {
				// TCY
				return S_FALSE;
			}
		}

		// RNVɒǉ
		CComVariant varUrl(url);
		return pImgUrl->put_item(varUrl, varUrl);
	}

	CComPtr<ISettingAcceptors> pSetting_;

	CComPtr<IScriptObject> pScriptObject_;
};

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CHTMLElementFilter), CHTMLElementFilter);


HRESULT __stdcall CreateHTMLElementFilter(IHTMLElementFilter** v_ppHTMLElementFilter) throw()
{
	return CHTMLElementFilter::CreateInstance(v_ppHTMLElementFilter);
}
