// IniConfSample.cpp : R\[ AvP[ṼGg |Cg`܂B
//

#include "stdafx.h"

#include <shlobj.h>

#include "../IniConf/Configuration.h"

class CIniConfSample
	: public CAtlExeModuleT<CIniConfSample>
{
public:

	HRESULT PreMessageLoop(int v_nShowCmd) throw()
	{
		HRESULT hr = __super::PreMessageLoop(v_nShowCmd);
		if (FAILED(hr)) {
			return hr;
		}
		return S_OK;
	}

	void RunMessageLoop() throw()
	{
		HRESULT hr;

		CComBSTR moduleBase;
		hr = GetModuleDirectory(NULL, &moduleBase);
		ATLASSERT(SUCCEEDED(hr));

		std::wcout << (LPCWSTR) moduleBase << std::endl;

		CComBSTR moduleBaseDir;
		hr = GetModuleBaseDirectory(NULL, L"testdir", TRUE, &moduleBaseDir);
		ATLASSERT(SUCCEEDED(hr));

		std::wcout << (LPCWSTR) moduleBaseDir << std::endl;

		CComBSTR specialFolder;
		hr = GetShellSpecialFolderBaseDirectory(CSIDL_LOCAL_APPDATA, L"testdir", FALSE, &specialFolder);
		ATLASSERT(SUCCEEDED(hr));

		std::wcout << (LPCWSTR) specialFolder << std::endl;

		CAtlStringW iniFilePath(moduleBaseDir);
		iniFilePath += L"test.ini";

		CComPtr<IConfStrageDir> pStrageDir;
		hr = GetConfStrageDir(iniFilePath, &pStrageDir);
		ATLASSERT(SUCCEEDED(hr));

		CComPtr<IConfStrage> pStrage1;
		hr = pStrageDir->OpenStrage(L"Section1", &pStrage1);
		ATLASSERT(SUCCEEDED(hr));

		hr = pStrage1->WriteInt(L"VALUE1", 1234);
		ATLASSERT(SUCCEEDED(hr));

		hr = pStrage1->WriteString(L"VALUE2", L"ABCDE");
		ATLASSERT(SUCCEEDED(hr));

		int value1;
		hr = pStrage1->GetInt(L"VALUE1", 0, &value1);
		ATLASSERT(SUCCEEDED(hr));
		ATLASSERT(value1 == 1234);

		CComBSTR value2;
		hr = pStrage1->GetString(L"VALUE2", NULL, &value2);
		ATLASSERT(SUCCEEDED(hr));
		ATLASSERT(value2 == L"ABCDE");

		CComBSTR value3;
		hr = pStrage1->GetString(L"VALUE3", NULL, &value3);
		ATLASSERT(SUCCEEDED(hr));
		ATLASSERT(value3);
		ATLASSERT(value3 == L"");

		CComPtr<IConfStrageEnumEntries> pEntries;
		hr = pStrage1->EnumEntries(&pEntries);
		ATLASSERT(SUCCEEDED(hr));

		CComBSTR name;
		while (pEntries->Next(&name) == S_OK) {
			std::wcout << (LPCWSTR) name << std::endl;
			name.Empty();
		}

		CComPtr<IConfStrageDirEnumStrages> pEnumStrages;
		hr = pStrageDir->EnumStrages(&pEnumStrages);
		ATLASSERT(SUCCEEDED(hr));

		CComBSTR strageName;
		CComPtr<IConfStrage> pStrage2;
		while (pEnumStrages->Next(&strageName, &pStrage2) == S_OK) {
			std::wcout << (LPCWSTR) strageName << std::endl;

			FILETIME ft;
			GetSystemTimeAsFileTime(&ft);
			hr = pStrage2->WriteData(L"filetime", &ft, sizeof(FILETIME));
			ATLASSERT(SUCCEEDED(hr));

			FILETIME ft2;
			hr = pStrage2->GetData(L"filetime", &ft2, sizeof(FILETIME));
			ATLASSERT(SUCCEEDED(hr));
			ATLASSERT(memcmp(&ft, &ft2, sizeof(FILETIME)) == 0);

			strageName.Empty();
			pStrage2.Release();
		}
	}
};

CIniConfSample _AtlModule;

int _tmain(int argc, _TCHAR* argv[])
{
	_AtlModule.WinMain(SW_SHOWNORMAL);
	return 0;
}

