#include "stdafx.h"

#include <shlobj.h>

#include "Configuration.h"

namespace
{
	void GetModuleBaseDir(HINSTANCE v_hInst, CAtlStringW& v_path)
	{
		int bufsiz = MAX_PATH;
		CAtlString pathbuf;
		for (;;) {
			LPTSTR pBuf = pathbuf.GetBufferSetLength(bufsiz + 1);
			DWORD dwFLen = ::GetModuleFileName(v_hInst, pBuf, bufsiz);
			if (dwFLen == 0) {
				// W[̃pX̎擾Ɏs
				AtlThrow(AtlHresultFromLastError());
			}
			pBuf[dwFLen] = 0;
			pathbuf.ReleaseBufferSetLength(dwFLen + 1);
			if (dwFLen == bufsiz) {
				bufsiz *= 2; // obt@sĂ̂ŃgC
				continue;
			}
			break;
		}

		LPTSTR pSt = pathbuf.GetBuffer();
		LPTSTR p = pSt;
		while (*p) p++;
		for (;;) {
			if (*p == '\\') {
				*p = 0;
				break;
			}
			if (p <= pSt) {
				// tH_؂肪ǂɂȂB
				break;
			}
			p = CharPrev(pSt, p);
		}
		pathbuf.ReleaseBuffer();

		v_path = pathbuf;
		v_path += L"\\";
	}

	void GetShellSpecialDir(int v_folder, CAtlStringW& v_path)
	{
		TCHAR path[MAX_PATH];
		if ( !::SHGetSpecialFolderPath(NULL, path, v_folder, TRUE)) {
			AtlThrow(E_FAIL);
		}
		v_path = path;

		// u\vŏI[B
		LPCWSTR p = v_path;
		WCHAR lastChr = 0;
		while (*p) {
			lastChr = *p;
			p++;
		}
		if (lastChr != '\\') {
			v_path += L"\\";
		}
	}

	void MakeSubDirectory(LPCWSTR v_pDirName, BOOL v_ensureExistDir, CAtlStringW& path)
	{
		if (v_pDirName && *v_pDirName) {
			LPCWSTR pDirName = v_pDirName;
			
			// 擪̋󔒂Ɓu\v̓XLbvB
			while (*pDirName == '\\' || *pDirName == ' ') pDirName++;

			// ǉ̃fBNg
			path += pDirName;

			//́u\vŏI
			WCHAR lastChr = 0;
			while (*pDirName) {
				lastChr = *pDirName;
				pDirName++;
			}
			if (lastChr != '\\') {
				path += L"\\";
			}

			// fBNg쐬
			if (v_ensureExistDir) {
				int errcode = ::SHCreateDirectory(NULL, path);
				DWORD attr = ::GetFileAttributes(path);
				if (attr == -1 || !(attr & FILE_ATTRIBUTE_DIRECTORY)) {
					if (errcode != ERROR_SUCCESS) {
						AtlThrow(AtlHresultFromWin32(errcode));
					}
					AtlThrow(AtlHresultFromWin32(ERROR_PATH_NOT_FOUND));
				}
			}
		}
	}
}

HRESULT __stdcall GetModuleDirectory(HINSTANCE v_hInst, BSTR* v_pBaseDir) throw()
{
	if ( !v_pBaseDir) {
		return E_POINTER;
	}
	ATLASSERT(!*v_pBaseDir);

	try {
		*v_pBaseDir = NULL;

		CAtlStringW path;

		GetModuleBaseDir(v_hInst, path);

		CComBSTR tmp(path);
		*v_pBaseDir = tmp.Detach();
		return S_OK;
	}
	catch (const CAtlException& exception) {
		return exception.m_hr;
	}
	catch (...) {
		return E_FAIL;
	}
}

HRESULT __stdcall GetModuleBaseDirectory(HINSTANCE v_hInst,
	LPCWSTR v_pDirName, BOOL v_ensureExistDir, BSTR* v_pBaseDir) throw()
{
	if ( !v_pBaseDir) {
		return E_POINTER;
	}
	ATLASSERT(!*v_pBaseDir);

	try {
		*v_pBaseDir = NULL;

		CAtlStringW path;

		GetModuleBaseDir(v_hInst, path);
		MakeSubDirectory(v_pDirName, v_ensureExistDir, path);

		CComBSTR tmp(path);
		*v_pBaseDir = tmp.Detach();
		return S_OK;
	}
	catch (const CAtlException& exception) {
		return exception.m_hr;
	}
	catch (...) {
		return E_FAIL;
	}
}

HRESULT __stdcall GetShellSpecialFolderBaseDirectory(int v_folder,
	LPCWSTR v_pDirName, BOOL v_ensureExistDir, BSTR* v_pBaseDir) throw()
{
	if ( !v_pBaseDir) {
		return E_POINTER;
	}
	ATLASSERT(!*v_pBaseDir);

	try {
		*v_pBaseDir = NULL;

		CAtlStringW path;

		GetShellSpecialDir(v_folder, path);
		MakeSubDirectory(v_pDirName, v_ensureExistDir, path);

		CComBSTR tmp(path);
		*v_pBaseDir = tmp.Detach();
		return S_OK;
	}
	catch (const CAtlException& exception) {
		return exception.m_hr;
	}
	catch (...) {
		return E_FAIL;
	}
}
