#include "stdafx.h"

#include "Configuration.h"
#include "ConfStrage.h"
#include "ConfStrageEnumEntries.h"

HRESULT CConfStrageEnumEntries::FinalConstruct() throw()
{
	return S_OK;
}

void CConfStrageEnumEntries::FinalRelease() throw()
{
	pConfStrage_.Release();
}

HRESULT CConfStrageEnumEntries::Init(CConfStrage* v_pConfStrage) throw()
{
	if ( !v_pConfStrage) {
		return E_INVALIDARG;
	}

	try {
		pConfStrage_ = v_pConfStrage;

		const CAtlString& sectionName = v_pConfStrage->sectionName_;
		const CAtlString& iniFilePath = v_pConfStrage->iniFilePath_;

		int bufsiz = 4096;
		for (;;) {
			LPTSTR pBuf = dblNulledData_.GetBufferSetLength(bufsiz);
			int ret = ::GetPrivateProfileSection(
				sectionName,
				pBuf,
				bufsiz,
				iniFilePath
				);
			dblNulledData_.ReleaseBuffer(ret + 2);
			if (ret == bufsiz - 2) {
				// obt@Ȃ
				bufsiz *= 2;
				continue;
			}
			break;
		}

		p_ = dblNulledData_.LockBuffer();
	}
	catch (const CAtlException& exception) {
		return exception.m_hr;
	}
	catch (...) {
		return E_FAIL;
	}

	return S_OK;
}

/// IConfStrageEnumEntries ///

HRESULT __stdcall CConfStrageEnumEntries::Next(BSTR* v_pName) throw()
{
	ATLASSERT(pConfStrage_);

	ObjectLock lock(this);

	try {
		if (v_pName) {
			ATLASSERT( !*v_pName);
			*v_pName = NULL;
		}

		if (!*p_) {
			// [ɓBĂ
			return S_FALSE;
		}

		LPCTSTR pSt = p_;
		LPCTSTR pEn = NULL;
		while (*p_) {
			if ( !pEn && (*p_ == '=')) {
				pEn = p_;
			}
			p_ = CharNext(p_);
		}
		if (!pEn) {
			pEn = p_;
		}
		p_++; // ɐi߂

		if (v_pName) {
			size_t len = pEn - pSt;
			CAtlStringW tmp(pSt, static_cast<int>(len));
			CComBSTR ret(tmp);
			*v_pName = ret.Detach();
		}

		return S_OK;
	}
	catch (const CAtlException& exception) {
		return exception.m_hr;
	}
	catch (...) {
		return E_FAIL;
	}
}
