#include "stdafx.h"

#include "Configuration.h"
#include "ConfStrage.h"
#include "ConfStrageDir.h"
#include "ConfStrageDirEnumStrages.h"

HRESULT CConfStrageDir::FinalConstruct() throw()
{
	return S_OK;
}

HRESULT CConfStrageDir:: Init(LPCWSTR v_pIniFilePath) throw()
{
	if ( !v_pIniFilePath || !*v_pIniFilePath) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}
	try {
		iniFilePath_ = v_pIniFilePath;
	}
	catch (...) {
		ATLASSERT(false);
		return E_FAIL;
	}
	return S_OK;
}

/// IConfStrageDir ///

HRESULT __stdcall CConfStrageDir::OpenStrage(LPCWSTR v_pName, IConfStrage** v_ppStrage) throw()
{
	ATLASSERT( !iniFilePath_.IsEmpty());

	if ( !v_ppStrage) {
		ATLASSERT(false);
		return E_POINTER;
	}
	if ( !v_pName || !*v_pName) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	ObjectLock lock(this);

	try {
		CComPtr<IConfStrage> pConfStrage;

		CSectionMap::CPair* pPair = sectionMap_.Lookup(v_pName);
		if (pPair) {
			pConfStrage = pPair->m_value;
		}
		else {
			HRESULT hr;
			CComObject<CConfStrage>* pConfStrageImpl = NULL;
			hr = CComObject<CConfStrage>::CreateInstance(&pConfStrageImpl);
			if (FAILED(hr)) {
				ATLASSERT(false);
				return hr;
			}
			CComPtr<IConfStrage> pTempConfStrage(pConfStrageImpl);
			ATLASSERT(pTempConfStrage);

			hr = pConfStrageImpl->Init(v_pName, iniFilePath_);
			if (FAILED(hr)) {
				ATLASSERT(false);
				return hr;
			}

			sectionMap_.SetAt(v_pName, pTempConfStrage);

			pConfStrage = pTempConfStrage;
		}

		ATLASSERT(pConfStrage);
		return pConfStrage.CopyTo(v_ppStrage);
	}
	catch (...) {
		ATLASSERT(false);
		return E_FAIL;
	}
}

HRESULT __stdcall CConfStrageDir::EnumStrages(IConfStrageDirEnumStrages** v_ppEnumStrages) throw()
{
	if ( !v_ppEnumStrages) {
		ATLASSERT(false);
		return E_POINTER;
	}
	ATLASSERT(!*v_ppEnumStrages);

	ObjectLock lock(this);

	try {
		int bufsiz = 4096;
		CAtlString buf;

		for (;;) {
			LPTSTR pBuf = buf.GetBufferSetLength(bufsiz);
			int ret = ::GetPrivateProfileSectionNames(
				pBuf,
				bufsiz,
				iniFilePath_
				);
			buf.ReleaseBuffer(ret + 2);
			if (ret == bufsiz - 2) {
				// obt@Ȃ
				bufsiz *= 2;
				continue;
			}
			break;
		}

		LPCTSTR p = buf.LockBuffer();
		while (*p) {
			CAtlStringW name(p);
			while (*p++); // I[܂œǂݔ΂B(I[܂)

			// Xg[W擾B
			HRESULT hr;
			CComPtr<IConfStrage> pStrage;
			hr = OpenStrage(name, &pStrage);
			if (FAILED(hr)) {
				ATLASSERT(false);
				return hr;
			}
		}

		HRESULT hr;
		CComObject<CConfStrageDirEnumStrages>* pEnumStragesImpl = NULL;
		hr = CComObject<CConfStrageDirEnumStrages>::CreateInstance(&pEnumStragesImpl);
		if (FAILED(hr)) {
			return hr;
		}
		CComPtr<IConfStrageDirEnumStrages> pEnumStrages(pEnumStragesImpl);
		ATLASSERT(pEnumStrages);

		hr = pEnumStragesImpl->Init(this);
		if (FAILED(hr)) {
			return hr;
		}

		return pEnumStrages.CopyTo(v_ppEnumStrages);
	}
	catch (const CAtlException& exception) {
		return exception.m_hr;
	}
	catch (...) {
		return E_FAIL;
	}
}

//////////////////////////////


HRESULT __stdcall GetConfStrageDir(LPCWSTR v_pIniFilePath, IConfStrageDir** v_ppConfStrageDir) throw()
{
	if ( !v_pIniFilePath || !*v_pIniFilePath) {
		return E_INVALIDARG;
	}
	if ( !v_ppConfStrageDir) {
		ATLASSERT(false);
		return E_POINTER;
	}
	ATLASSERT(!*v_ppConfStrageDir);

	HRESULT hr;

	CComObject<CConfStrageDir>* pConfStrageDirImpl = NULL;
	hr = CComObject<CConfStrageDir>::CreateInstance(&pConfStrageDirImpl);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return hr;
	}
	CComPtr<IConfStrageDir> pConfStrageDir(pConfStrageDirImpl);
	ATLASSERT(pConfStrageDir);

	hr = pConfStrageDirImpl->Init(v_pIniFilePath);
	if (FAILED(hr)) {
		ATLASSERT(false);
		return hr;
	}

	return pConfStrageDir.CopyTo(v_ppConfStrageDir);
}
