#!/usr/bin/perl
#
# Script generating new translation from template, using old translation.
# Option usage:
# /h or /help, Display option usage.
# /i set filename of existed langpack_english.txt. Default is langpack_english.txt.
# /o set filename of new langpack_local. Default is langpack_local.txt.
# /d set filename of existed langpack_DB or existed langpack_local. Default is langpack_DB.txt.
#
# Miranda IM: the free IM client for Microsoft* Windows*
# 
# Copyright 2000-2008 Miranda ICQ/IM project,
# all portions of this codebase are copyrighted to the people
# listed in contributors.txt.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

use POSIX;
use strict;
use warnings;

my %old_headers;
my @all_headers = ("Miranda Language Pack","Language:","Locale:","Authors:","Author-email:","Last-Modified-Using:","Plugins-included:","; Generated by lpgen on","; Translations:","; FLID:");
my @headers = ("Language:","Locale:","Authors:","Author-email:","Plugins-included:","; FLID:");

#Get filename from argument

#default filename
my $lang_english = 'langpack_english.txt';
my $lang_local = 'langpack_local.txt';
my $langDB_file = 'langpack_DB.txt';

my %filename;
my $error_check = 0;

#Check argument count
if(@ARGV > 3)
{
	$error_check = 1;
}
foreach my $get_argument ( @ARGV )
{
#Check help option
	if( $get_argument =~ /^\/(h|help)$/ )
	{
		$error_check = 1;
		next;
	}
#Check argument format
	if( $get_argument =~ /^\/(i|o|d):(.*?)$/ )
	{
#Check duplicates
		if( !$filename{$1} )
		{
			$filename{$1} = $2;
		}
		else
		{
			$error_check = 1;
		}
	}
	else
	{
		$error_check = 1;
	}
}
if( $error_check == 1 )
{
	print " '$0' </i:existed langpack_english.txt> </o:new langpack_local.txt> </d:existed langpack_DB.txt>\n";
	exit;
}
if( $filename{i} )
{
	$lang_english = $filename{i};
}
if( $filename{o} )
{
	$lang_local = $filename{o};
}
if( $filename{d} )
{
	$langDB_file = $filename{d};
}

#Get words from exited langDBfile or langpack_*.txt.
my %old_trans = get_langDB( $langDB_file, @all_headers );

#Pre-Header-Processing.
my %new_headers = get_newheader( $lang_english, @all_headers );

#Get words from new langpack_english.txt
open my $fh1, '<', $lang_english
	or die qq/Error : Cannot open "$lang_english": $!/;

#Write result to tempfile
my $temp_file = "\$file.\$\$.";
open my $fh2, '>', $temp_file
	or die qq/Error : Cannot open "$temp_file": $!/;

my $header_check = 0;
foreach my $all_header ( @all_headers )
{
	foreach my $header ( @headers )
	{
		if( $header eq $all_header )
		{
			printf $fh2 "%s\n", $old_headers{$header};
			$header_check = 1;
			last;
		}
	}
	if( $header_check == 0 )
	{
		printf $fh2 "%s\n", $new_headers{$all_header};
	}
	$header_check = 0;
}
printf $fh2 "\n";

#Body
while( my $ignore_line = <$fh1>)
{
	chomp $ignore_line;
	if( $ignore_line =~ /; Common strings that belong to many files/)
	{
		printf $fh2 "%s\n", $ignore_line;
		last;
	}
}

while( my $get_line = <$fh1> )
{
	chomp $get_line;
	if( $get_line =~ /^;(\[(.*?)\]$)/ and $old_trans{$1} )
	{
		printf $fh2 "%s\n%s\n", $1, $old_trans{$1};
		next;
	}
	else
	{
		printf $fh2 "%s\n", $get_line;
	}
}
close $fh1;
close $fh2;

#Rename tempfile to langpack_*.txt.
rename $temp_file, $lang_local
	or die qq/Error : Cannot move "$temp_file" to "$lang_local": $!/;


#Get words from exited langDB.
sub get_langDB
{
	my ($langDB_file, @all_headers) = @_;
	my %old_trans;
	my $key = '';

	open my $fh, '<', $langDB_file
		or die qq/Error : Cannot open "$langDB_file": $!/;

	while( my $get_line = <$fh>)
	{
		chomp $get_line;
		foreach my $all_header ( @all_headers )
		{
			if( $get_line =~ /^$all_header/)
			{
				$old_headers{$all_header} = $get_line;
				last;
			}
		}
		if( $get_line =~ /^\[(.*?)\]$/ )
		{
			$key = $get_line;
			$get_line = <$fh>;
			chomp $get_line;
			$old_trans{$key} = $get_line;
			next;
		}
	}
	close $fh;
	return %old_trans;
}

#Pre-Header-Processing.
sub get_newheader
{
	my ($lang_english, @all_headers) = @_;
	my %new_headers;

	open my $fh, '<', $lang_english
		or die qq/Error : Cannot open "$lang_english": $!/;

	while( my $get_line = <$fh>)
	{
		chomp $get_line;
		if( $get_line =~ /^; Common strings that belong to many files/)
		{last;}

		foreach my $all_header ( @all_headers )
		{
			if( $get_line =~ /^$all_header/ )
			{
				$new_headers{$all_header} = $get_line;
			}
		}
	}
	close $fh;
	return %new_headers;
}
