#!/usr/bin/perl
#
# Thie Script generate a langpack_DB.txt included all translation using existing langpack_*.
# Words in langpack_* will overwrite the previously saved words in langpack_DB.txt.
# Option usage:
# /h or /help, Display option usage.
# /f set filename of langpack_DB. Default is langpack_DB.txt.
#
# Copyright 2012 Miranda JP project.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


use POSIX;
use strict;
use warnings;

#Check argument
my %filename;
my $error_check = 0;

my $langDB_file = 'langpack_DB.txt';
my @lang_files = ();

#Check argument count
if( @ARGV == 0 )
{
	$error_check = 1;
}
foreach my $get_argument ( @ARGV )
{
#Check help option
	if( $get_argument =~ /^\/(h|help)$/ )
	{
		$error_check = 1;
		next;
	}
#Check argument format
	if( $get_argument =~ /^\/(f):(.*?)$/ )
	{
#Check duplicates
		if( !$filename{$1} )
		{
			$filename{$1} = $2;
		}
		else
		{
			$error_check = 1;
		}
	}
	else
	{
		push @lang_files, $get_argument;
	}
}
if( $error_check == 1 )
{
	print " '$0' </f:new langpack_DB.txt> <old langpack_* > [<next langpack_*> ...]\n";
	exit;
}
if( $filename{f} )
{
	$langDB_file = $filename{f};
}

#Get words from exited langDB.
my $key = '';
my %headers;
my @headers = ("Miranda Language Pack","Language:","Locale:","Authors:","Author-email:","Last-Modified-Using:","Plugins-included:","; Generated by lpgen on","; Translations:","; FLID:");
my %trans;

if ( open my $fh, '<', $langDB_file )
{
	while( my $get_line = <$fh>)
	{
		chomp $get_line;
		foreach my $header ( @headers )
		{
			if( $get_line =~ /^$header/)
			{
				$headers{$header} = $get_line;
				last;
			}
		}
		if( $get_line =~ /^\[(.*?)\]$/ )
		{
			$key = $get_line;
			$get_line = <$fh>;
			chomp $get_line;
			$trans{$key} = $get_line;
		}
	}
	close $fh;
}

#Get words from langpack_*.
foreach my $lang_file (@lang_files)
{
	open my $fh, '<', $lang_file
		or die qq/Error : Cannot open "$lang_file": $!/;
	while( my $get_line = <$fh>)
	{
		chomp $get_line;
		foreach my $header ( @headers )
		{
			if( $get_line =~ /^$header/)
			{
				$headers{$header} = $get_line;
				next;
			}
		}
		if( $get_line =~ /^\[(.*?)\]$/ )
		{
			$key = $get_line;
			$get_line = <$fh>;
			chomp $get_line;
			$trans{$key} = $get_line;
		}
	}
	close $fh;
}

#Sort orignal words in alphabetical order.
my @keywords =  sort( keys ( %trans ));

#All result write to tempfile.
my $temp_file = "\$file.\$\$.";
open my $fh1, '>', $temp_file
	or die qq/Error : Cannot open "$temp_file": $!/;

foreach my $header (@headers)
{
	printf $fh1 "%s\n", $headers{$header};
}
print $fh1 "\n";
foreach my $keyword (@keywords)
{
	printf $fh1 "%s\n%s\n", $keyword, $trans{$keyword};
}
close $fh1;

#Rename tempfile to langDB.
rename $temp_file, $langDB_file
	or die qq/Error : Cannot move "$temp_file" to "$langDB_file": $!/;
