﻿using System;
using System.Text;
using System.Text.RegularExpressions;
using System.Diagnostics;
using System.Collections.Generic;
using System.IO;

namespace Static
{
	class Utility
	{
		public static bool matching(string target, string pattern, out GroupCollection g)
		{
			Match match = new Regex(pattern).Match(target);
			g = match.Groups;
			return match.Success;
		}
		public static bool matching(string target, string pattern)
		{
			Match match = new Regex(pattern).Match(target);
			return match.Success;
		}
		public static string string_forward(string r, int num)
		{
			return r.Substring(num, r.Length - num);
		}
		public static bool text_load(string filename, out string[] ret)
		{
			try{
				List<string> q = new List<string>();
				FileInfo info = new FileInfo(filename);
				StreamReader f = info.OpenText();
				do{
					string t = f.ReadLine();
					if(t == null){
						break;
					}
					q.Add(t);
				}while(q.Count < 1000);
				f.Close();
				ret = q.ToArray();
				return true;
			}catch{
				ret = null;
				return false;
			}
		}
		public static bool text_save(string filename, string[] data)
		{
			try{
				StreamWriter f = new StreamWriter(filename, false);
				foreach(string t in data){
					f.WriteLine(t);
				}
				f.Close();
				return true;
			}catch{
				return false;
			}
		}
		public static bool binary_load(string name, out byte [] image)
		{
			image = null;
			try{
				Stream f = File.OpenRead(name);
				if(f.Length >= imagefile.Fds.MAX_SIZE){
					return false;
				}
				image = new byte [f.Length];
				f.Read(image, 0, (int) f.Length);
				f.Close();
				return true;
			}catch {
				return false;
			}
		}
		public static bool binary_save(string name, byte [] image)
		{
			try{
				File.WriteAllBytes(name, image);
				return true;
			}catch {
				return false;
			}
		}
		public static byte [] memory_new_fill(int size, byte data)
		{
			byte [] ret = new byte[size];
			for(int i = 0; i < size; i++){
				ret[i] = data;
			}
			return ret;
		}
	}
}
namespace mdc5
{
	class DiskInfomation
	{
		string m_savefilename = "";
		Interface.DiskHash m_hash; // = new Interface.DiskHash();

		bool m_set = false;
		public bool Valid{
			get{ return m_set;}
		}
		public string Savefilename
		{
			get { return m_savefilename; }
			set { m_savefilename = value; }
		}
		public Interface.DiskHash Hash
		{
			get { return m_hash; }
		}
		public void HashSet(byte [] d)
		{
			m_hash = new Interface.DiskHash(d);
			m_set = true;
		}
	}
	class Script
	{
		string m_version;
		string m_gamename, m_gamecode;
		string m_biosname;
		Interface.DiskHash m_hash;
		DiskInfomation[] m_side;
		RomRecoard.MotorolaSRecoard[] m_patch;
		//const string HASH_PATTERN = @"^(([0-9A-Fa-f]{2}){20})";
		string HASH_PATTERN;
		enum status{
			YET, OPEN, CLOSE
		};
		//---- property ----
		public RomRecoard.MotorolaSRecoard[] PatchData
		{
			get { return m_patch;}
		}
		public string BiosName
		{
			get {return m_biosname;}
		}
		public string GameName
		{
			get {return m_gamename;}
		}
		public string GameCode
		{
			get {return m_gamecode;}
		}
		public string Hash
		{
			get {return m_hash.ToString();}
		}
		public string DiskImageFilename
		{
			get; set;
		}
		//---- methods ----
		public Script()
		{
			HASH_PATTERN = "^";
			for(int i = 0; i < Interface.DiskHash.SIZE; i++){
				HASH_PATTERN += "([0-9A-Fa-f]{2})";
			}
			HASH_PATTERN += "$";
		}
		public bool Load(string[] text)
		{
			return load(text);
		}
		public bool Load(string filename)
		{
			string [] text;
			if(Static.Utility.text_load(filename, out text) == false){
				return false;
			}
			return load(text);
		}
		public string SavefileNameGet(int side)
		{
			Debug.Assert(side < m_side.Length);
			return m_side[side].Savefilename;
		}
		byte [] strtobyte(GroupCollection g)
		{
			byte[] hash = new byte[Interface.DiskHash.SIZE];
			for (int i = 0; i < hash.Length; i++){
				int j = i + 1;
				hash[i] = Convert.ToByte(g[j].Value, 16);
			}
			return hash;
		}
		bool load(string[] text)
		{
			List<RomRecoard.MotorolaSRecoard> patchQueue
				= new List<RomRecoard.MotorolaSRecoard>();
			int sidenum = 0;
			status patch = status.YET;
			if(text.Length == 0){
				return false;
			}
			//このloopで必要な情報を得られたら continue を使用する.
			foreach (string t in text){
				string pattern = @"^\s*#"; //コメントはskip
				if(Static.Utility.matching(t, pattern) == true){
					continue;
				}
				pattern = @"^\s*$"; //空行もskip
				if(Static.Utility.matching(t, pattern) == true){
					continue;
				}
				GroupCollection g;
				pattern = @"^([^\s]+)\s*=\s*([^#]+)";
				if(Static.Utility.matching(t, pattern, out g) == true){
					string field = g[2].Value.TrimEnd();
					switch (g[1].Value){
					case "scriptversion":
						m_version = field;
						continue;
					case "gamename":
						if(field.Length > 21 + 20){
							return false;
						}
						m_gamename = field;
						continue;
					case "gamecode":
						m_gamecode = field;
						continue;
					case "biosname":
						if(Static.Utility.matching(field, @"^[0-9A-Z\.,\x20]+$") == false){
							return false;
						}
						m_biosname = field;
						continue;
					case "sidenum":
						if(sidenum != 0){
							return false;
						}
						if(Static.Utility.matching(field, @"^\d+$") == false){
							return false;
						}
						int num = Convert.ToInt32(field, 10);
						if(num == 0 || num >= 9){
							return false;
						}
						sidenum = num;
						m_side = new DiskInfomation[num];
						for(int i = 0; i < num; i++){
							m_side[i] = new DiskInfomation();
						}
						continue;
					}
				}
				pattern = @"^disk(\d)\.side([AB])\.([^\s]+)\s*=\s*([^#]+)";
				if(Static.Utility.matching(t, pattern, out g) == true){
					int side = Convert.ToInt32(g[1].Value, 10) - 1;
					side *= 2;
					if(g[2].Value == "B"){
						side += 1;
					}
					if(sidenum < side || sidenum == 0){
						return false;
					}
					string field = g[4].Value.TrimEnd();
					switch (g[3].Value){
					case "hash":
						if(Static.Utility.matching(field, HASH_PATTERN, out g) == false){
							return false;
						}
						m_side[side].HashSet(strtobyte(g));
						continue;
					case "savefilename":
						m_side[side].Savefilename = field;
						continue;
					}
				}
				switch (t){
				case "patch_start":
					if(patch != status.YET){
						return false;
					}
					patch = status.OPEN;
					continue;
				case "patch_end":
					if(patch != status.OPEN){
						return false;
					}
					patch = status.CLOSE;
					continue;
				default:
					if(patch != status.OPEN){
						//未定義 field なので error を返す
						return false;
					}
					RomRecoard.MotorolaSRecoard r = new RomRecoard.MotorolaSRecoard(t);
					if(r.Error == true){
						return false;
					}
					patchQueue.Add(r);
					break;
				}
			}
			m_patch = patchQueue.ToArray();
			m_hash = new Interface.DiskHash();
			foreach(DiskInfomation t in m_side){
				if(t.Valid == false){
					return false;
				}
				m_hash.Transform(t.Hash.Hash);
			}
			m_hash.Final();
			return true;
		}
	}
}
