/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.editors.linkeventsrc;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.digester.Digester;
import org.maskat.xml.digester.MaskatDigester;
import org.xml.sax.SAXException;

public class LinkConfig {
	private List layoutFileCfgs;

	public void addLayoutFileCfg(LayoutFileCfg layoutFileCfg) {
		if (layoutFileCfgs == null)
			layoutFileCfgs = new ArrayList();
		layoutFileCfgs.add(layoutFileCfg);
	}

	public String[] findEventFileNames(String layoutFileName) {
		if (layoutFileCfgs == null)
			return null;
		for (Iterator it = layoutFileCfgs.iterator(); it.hasNext();) {
			LayoutFileCfg layoutFileCfg = (LayoutFileCfg) it.next();
			if (layoutFileName.equals(layoutFileCfg.getName())) {
				return layoutFileCfg.getEventFileNames();
			}
		}
		return null;
	}

	public static LinkConfig load(InputStream linkFileStream) throws IOException,
			SAXException {
		Digester digester = new MaskatDigester();
		digester.addObjectCreate("config", LinkConfig.class);

		digester.addObjectCreate("*/layoutFile", LayoutFileCfg.class);
		digester.addSetProperties("*/layoutFile");
		digester.addSetNext("*/layoutFile", "addLayoutFileCfg", LayoutFileCfg.class
				.getName());

		digester.addObjectCreate("*/eventFile", EventFileCfg.class);
		digester.addSetProperties("*/eventFile");
		digester.addSetNext("*/eventFile", "addEventFileCfg", EventFileCfg.class
				.getName());
		return (LinkConfig) digester.parse(linkFileStream);
	}
}
