/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.tabbedproperties;

import java.lang.reflect.InvocationTargetException;

import org.apache.commons.beanutils.PropertyUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.maskat.ide.editors.MaskatEditor;

public class CComboValueWatcher implements FocusListener {

	private String oldValue;

	private Object beanObj;

	private String prop;

	private CCombo combo;

	/** TODO should have a instance of CommandStack instead of an editor */
	protected MaskatEditor editor;

	public CComboValueWatcher(CCombo combo, Object obj, String prop, MaskatEditor editor) {
		this.combo = combo;
		this.beanObj = obj;
		this.prop = prop;
		this.editor = editor;
	}

	public void focusGained(FocusEvent e) {
		oldValue = combo.getText();
	}

	public void focusLost(FocusEvent e) {
		String newValue = combo.getText();
		if (!oldValue.equals(newValue)) {
			if ("".equals(newValue)) {
				newValue = null;
			}
			try {
				// Set the newValue to the object.
				// TODO should be command here(CommandStack)
				PropertyUtils.setProperty(beanObj, prop, newValue);
				editor.makeDirty();
			} catch (IllegalAccessException e1) {
				e1.printStackTrace();
			} catch (InvocationTargetException e1) {
				e1.printStackTrace();
			} catch (NoSuchMethodException e1) {
				e1.printStackTrace();
			}
		}
	}
}
