/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.property;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ui.views.properties.IPropertySource;
import org.maskat.framework.eventdef.Component;
import org.maskat.framework.screendef.ComboItemDef;
import org.maskat.framework.screendef.DivSplitDef;
import org.maskat.framework.screendef.GridHeaderDef;
import org.maskat.framework.screendef.IComponentDef;
import org.maskat.framework.screendef.IContainerDef;
import org.maskat.framework.screendef.LayoutDef;
import org.maskat.ide.gef.models.SplitModel;
import org.maskat.ide.gef.models.TabDef;

/**
 * ComponentDef->IPropertySouce
 * 
 * @author shengshen
 * 
 */
public class PropertyAdapterFactory implements IAdapterFactory {

	public Object getAdapter(Object adaptableObject, Class adapterType) {
		if (adapterType == IPropertySource.class) {
			if (adaptableObject instanceof DivSplitDef
					|| adaptableObject instanceof GridHeaderDef
					|| adaptableObject instanceof TabDef
					|| adaptableObject instanceof ComboItemDef) {
				ComponentProperty cp = new ComponentProperty();
				cp.setComponentDef(adaptableObject);
				return cp;
			}
			if (adaptableObject instanceof SplitModel) {
				ComponentProperty cp = new ComponentProperty();
				cp.setComponentDef(((SplitModel) adaptableObject).getParent());
				return cp;
			}
			if (adaptableObject instanceof IComponentDef) {
				IComponentDef compDef = (IComponentDef) adaptableObject;

				IContainerDef root = compDef.getLayoutDef();
				ComponentProperty cp = null;
				LayoutDef sdf = (LayoutDef) root;
				if (compDef instanceof LayoutDef) {
					LayoutProperty lp = (LayoutProperty) sdf.getLayoutEvtDefSrc()
							.getDefs()[0];
					lp.setLayoutDef(sdf);
					return lp;
				}
				Component component = sdf.getLayoutEvtDefSrc().findComponent(
						compDef.getName());

				cp = (ComponentProperty) component;
				cp.setComponentDef(compDef);
				return cp;
			}
		}
		return null;
	}

	public Class[] getAdapterList() {
		return new Class[] { IPropertySource.class };
	}

}
