/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.editpolicies;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.maskat.framework.screendef.DivSplitDef;
import org.maskat.framework.screendef.GridDef;
import org.maskat.framework.screendef.GridHeaderDef;
import org.maskat.framework.screendef.IComponentDef;
import org.maskat.framework.screendef.IContainerDef;
import org.maskat.framework.screendef.LayoutDef;
import org.maskat.ide.gef.commands.DelBasicDefCommand;
import org.maskat.ide.gef.commands.DelGridHeaderCommand;

public class MaskatComponentEditPolicy extends ComponentEditPolicy {
	public Command getCommand(Request request) {
		// |bvAbvj[Ɂu폜vDelComponentAction
		if ("maskat.delete".equals(request.getType())) {
			return createDeleteCommand(null);
		}
		return super.getCommand(request);
	}

	protected Command createDeleteCommand(GroupRequest deleteRequest) {
		Object model = getHost().getModel();
		if (model instanceof GridHeaderDef) {
			GridDef grid = ((GridHeaderDef) model).getParent();
			return new DelGridHeaderCommand(grid, (GridHeaderDef) model);
		}
		if (model instanceof IComponentDef) {
			IComponentDef comp = (IComponentDef) model;
			if (comp instanceof LayoutDef) {
				return null;
			}
			if (comp instanceof DivSplitDef) {
				return null;
			}
			return new DelBasicDefCommand(comp.getParentDef(), comp);
		}
		return null;
	}

	protected boolean canFeedbackToRequest(Request request) {
		Object model = getHost().getModel();
		if (model instanceof IContainerDef && !(model instanceof LayoutDef)) {
			return true;
		}
		return false;
	}

	public void showTargetFeedback(Request request) {
		if (canFeedbackToRequest(request)) {
			// TODO ChangeBoundsRequest̏ꍇAEditPart͐eEditPartړꍇA
			// nCCg\͂Ȃ悤
			boolean doHighlight = false;
			if (request instanceof CreateRequest) {
				doHighlight = true;
			}
			if (request instanceof ChangeBoundsRequest) {
				doHighlight = true;
			}
			if (doHighlight) {
				// nCCg\
				((AbstractGraphicalEditPart) getHost()).getFigure().setBackgroundColor(
						ColorConstants.lightGray);
				((AbstractGraphicalEditPart) getHost()).getFigure().setOpaque(true);
			}
		}
		super.showTargetFeedback(request);
	}

	public void eraseTargetFeedback(Request request) {
		if (canFeedbackToRequest(request)) {
			if (request instanceof CreateRequest
					|| request instanceof ChangeBoundsRequest) {
				((AbstractGraphicalEditPart) getHost()).getFigure().setBackgroundColor(
						ColorConstants.white);
				((AbstractGraphicalEditPart) getHost()).getFigure().setOpaque(false);
			}
		}
		super.eraseTargetFeedback(request);
	}
}
