/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.editparts;

import java.util.Iterator;

import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.maskat.framework.screendef.GridDef;
import org.maskat.framework.screendef.GridHeaderDef;
import org.maskat.ide.gef.editpolicies.MaskatComponentEditPolicy;

public class GridHeaderEditPart extends AbstractGraphicalEditPart {

	public static final int headerHeight = 20;

	public static final int headerTop = 20;

	public static final int minimalHeaderDisplayWidth = 10;

	protected IFigure createFigure() {
		Label label = new Label();
		label.setBorder(new CompoundBorder(new LineBorder(), new MarginBorder(0)));
		return label;
	}

	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.COMPONENT_ROLE, new MaskatComponentEditPolicy());
	}

	protected void refreshVisuals() {
		((Label) this.getFigure()).setText(((GridHeaderDef) this.getModel()).getTitle());
		// gridHeaderDef̏ꍇAsetLayoutConstraintconstraintvZ
		Object model = getModel();
		if (model instanceof GridHeaderDef) {
			GridHeaderDef gridHeader = (GridHeaderDef) getModel();
			int idx = gridHeader.idxInParent();
			GridDef grid = gridHeader.getParent();
			Iterator headersIt = grid.getHeadersIt();
			if (headersIt != null) {
				int left = 0;
				for (int i = 0; i < idx; i++) {
					int headerWidth = toHeaderDisplayWidth(((GridHeaderDef) headersIt
							.next()).getWidth());
					left += headerWidth;
				}
				Rectangle constraint = new Rectangle(left, headerTop,
						toHeaderDisplayWidth(gridHeader.getWidth()), headerHeight);
				((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
						constraint);
			}
		}
	}

	/**
	 * gridwb_[\p̕ԂiminimalHeaderDisplayWidthȉł΁AminimalHeaderDisplayWidthԂj<br>
	 * ܂Agridwb_[̕\ŏ
	 * 
	 * @param headerWidth
	 * @return
	 */
	public static int toHeaderDisplayWidth(String headerWidth) {
		try {
			int width = Integer.parseInt(headerWidth);
			return Math.max(width, minimalHeaderDisplayWidth);
		} catch (NumberFormatException e) {
			return minimalHeaderDisplayWidth;
		}
	}
}
