/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef.customize;

import java.util.Iterator;

/**
 * vOCŒ`Ăgi̒`<br>
 * plugin.xmlɊgi̖OAƂ`Ă<br>
 * IDEł́AXML`ɏ]AIPluginDefGEF̃fƂĐ
 * 
 * @author shengshen
 * 
 */
public interface IComponentPluginConfig {

	/**
	 * ̃vOC̖O擾<br>
	 * XML`componentvfname̒l
	 * 
	 * @return
	 */
	public String getNodeName();

	/**
	 * Get the namespace for the customized component. That is to say the
	 * namespace attribute of the component node in the definition plugin.xml.
	 * 
	 * @return
	 */
	public String getNamespace();

	public String getPrefix();

	public IContentFactory getContentFactory();

	/**
	 * PluginDefFactory gets the nodeName attribute and sets the nodeName by
	 * this method. Should only be call by PluginDefFactory.
	 * 
	 * @param name
	 */
	public void defineNodeName(String name);

	/**
	 * PluginDefFactory gets the namespace attribute and sets the namespace by
	 * this method. Should only be call by PluginDefFactory.
	 * 
	 * @param namespace
	 */
	public void defineNamespace(String namespace);

	/**
	 * PluginDefFactory gets the plugin's isContainer attribute and sets the
	 * isContainer by this method. Should only be call by PluginDefFactory.
	 * 
	 * @param isContainer
	 */
	public void defineIsContainer(String isContainer);

	public void definePrefix(String prefix);

	public void defineContentFactory(IContentFactory contentFactory);

	/**
	 * Define the properties according to the definition in the plugin.xml. To
	 * declare the existence of the named property. Should only be call by
	 * PluginDefFactory.<br>
	 * Note: attribute means "property" declared which is <em>not</em> of type
	 * "event". That is to say the attribute from the layout definition xml.
	 * 
	 * @param name
	 */
	public void defineProperty(PropertyPluginConfig config);

	/**
	 * 
	 * @param name
	 * @return true: property name is defined. false otherwise.
	 */
	public boolean isPropertyNameDefined(String name);

	public Iterator getPropertyNames();

	/**
	 * Get the non-removeable iterator for the <code>PropertyPluginConfig</code>
	 * under the component configuration in the plugin.xml.
	 * 
	 * @return
	 */
	public Iterator getPropertyConfigs();

	/**
	 * Given the property configuration in the customize component plugin, it
	 * could be derived that which attributes should be outputed in the layout
	 * definition xml.Returns a non-removeable iterator of the attributes.
	 * 
	 * @return
	 */
	public Iterator getAttributeNames();

	/**
	 * Find the property configuration with the name <code>propName</code>
	 * which belongs to this component.
	 * 
	 * @param propName
	 * @return
	 */
	public PropertyPluginConfig getPropertyConfig(String propName);

	/**
	 * If the isContainer attribute is set by "true", then returns true, else
	 * returns false;
	 * 
	 * @return
	 */
	public boolean isContainer();
}
