/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef.customize;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.maskat.framework.NoRemoveIterator;

public class ComponentPluginConfig implements IComponentPluginConfig {

	/**
	 * The definition name of the
	 */
	private String nodeName;

	private String namespace;

	private String isContainer;

	private String prefix;

	private IContentFactory contentFactory;

	private List propertyNames = new ArrayList();

	private List attributeNames = new ArrayList();

	/**
	 * List of PropertyPluginConfig
	 */
	private List propertyConfigs;

	public String getNamespace() {
		return namespace;
	}

	public String getNodeName() {
		return nodeName;
	}

	public String getPrefix() {
		return prefix;
	}

	public void defineNodeName(String name) {
		nodeName = name;
	}

	public void defineNamespace(String namespace) {
		this.namespace = namespace;
	}

	public boolean isPropertyNameDefined(String name) {
		if (propertyNames == null) {
			return false;
		}
		return propertyNames.contains(name);
	}

	public Iterator getPropertyNames() {
		return new NoRemoveIterator(propertyNames.iterator());
	}

	public void defineProperty(PropertyPluginConfig config) {
		if (propertyConfigs == null)
			propertyConfigs = new ArrayList();
		propertyConfigs.add(config);
		propertyNames.add(config.getName());
		if (!config.isEventProp()) {
			// not an event property, so it should be an attribute
			attributeNames.add(config.getName());
		}
	}

	public Iterator getPropertyConfigs() {
		return new NoRemoveIterator(propertyConfigs.iterator());
	}

	public Iterator getAttributeNames() {
		return new NoRemoveIterator(attributeNames.iterator());
	}

	public PropertyPluginConfig getPropertyConfig(String propName) {
		for (Iterator it = propertyConfigs.iterator(); it != null && it.hasNext();) {
			PropertyPluginConfig element = (PropertyPluginConfig) it.next();
			if (propName.equals(element.getName())) {
				return element;
			}
		}
		return null;
	}

	public void defineIsContainer(String isContainer) {
		this.isContainer = isContainer;
	}

	public void definePrefix(String prefix) {
		this.prefix = prefix;
	}

	public boolean isContainer() {
		return "true".equals(isContainer);
	}

	public IContentFactory getContentFactory() {
		return this.contentFactory;
	}

	public void defineContentFactory(IContentFactory contentFactory) {
		this.contentFactory = contentFactory;
	}
}