/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/**
 * Abstract implementation of IContainerDef
 * 
 * @author shengshen
 * 
 */
public abstract class ContainerDef extends ComponentDef implements IContainerDef {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IContainerDef#getAllChildComponentNames(java.util.Set)
	 */
	public void getAllChildComponentNames(Set result) {
		// R|[lg̖O
		Iterator componentsIt = this.getTypedChildren(ComponentDef.class);
		if (componentsIt == null)
			return;
		while (componentsIt.hasNext()) {
			IComponentDef comp = (IComponentDef) componentsIt.next();
			if (comp.getName() != null)
				result.add(comp.getName());
			if (comp instanceof ContainerDef) {
				((IContainerDef) comp).getAllChildComponentNames(result);
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IContainerDef#addChild(java.lang.Object)
	 */
	public void addChild(Object comp) {
		super.addChild(comp);
		// editpartŃCxg󂯎珈B
		firePropertyChange("addChild", "", null);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IContainerDef#getComponentChildren()
	 */
	public List getComponentChildren() {
		// R|[lg̖O
		Iterator componentsIt = this.getTypedChildren(ComponentDef.class);
		if (componentsIt == null)
			return Collections.EMPTY_LIST;

		List result = new ArrayList();
		while (componentsIt.hasNext()) {
			result.add(componentsIt.next());
		}
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IContainerDef#findChild(java.lang.String)
	 */
	public IComponentDef findChild(String name) {
		// R|[lg̖O
		Iterator componentsIt = this.getTypedChildren(ComponentDef.class);
		if (componentsIt == null)
			return null;
		while (componentsIt.hasNext()) {
			IComponentDef comp = (IComponentDef) componentsIt.next();
			if (name.equals(comp.getName())) {
				return comp;
			}
		}
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IContainerDef#removeChild(java.lang.Object)
	 */
	public void removeChild(Object obj) {
		super.removeChild(obj);
		firePropertyChange("removeChild", "", null);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.maskat.framework.screendef.IContainerDef#addChildToIdx(java.lang.Object,
	 *      int)
	 */
	public void addChildToIdx(Object comp, int idx) {
		super.addChildToIdx(comp, idx);
		// editpartŃCxg󂯎珈B
		firePropertyChange("addChild", "", null);
	}
}
