/*
 * Copyright 2006 Maskat Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef;


/**
 * XXX comboItem should not extends ComponentDef. It don't has many features of
 * component. for example: no name, no size...
 * 
 * @author shengshen
 * 
 */
public class ComboItemDef extends ComponentDef {

	private String text;

	private String value;

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
		this.firePropertyChange("text", null, "");
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

}
