/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import org.exolab.castor.util.OrderedHashMap;
import org.exolab.javasource.JAnnotationType;
import org.exolab.javasource.JSourceWriter;

public class JAnnotation {
    private JAnnotationType _annotationType;
    private OrderedHashMap _elementValues = new OrderedHashMap();
    public static final String value = "value";

    public JAnnotation(JAnnotationType annotationType) {
        this._annotationType = annotationType;
    }

    public JAnnotationType getAnnotationType() {
        return this._annotationType;
    }

    public void setValue(String stringValue) {
        this._elementValues.put(value, stringValue);
    }

    public void setValue(String[] stringValue) {
        this._elementValues.put(value, stringValue);
    }

    public void setValue(JAnnotation annotationValue) {
        this._elementValues.put(value, annotationValue);
    }

    public void setValue(JAnnotation[] annotationValues) {
        this._elementValues.put(value, annotationValues);
    }

    public void setElementValue(String elementName, String stringValue) {
        this._elementValues.put(elementName, stringValue);
    }

    public void setElementValue(String elementName, String[] stringValues) {
        this._elementValues.put(elementName, stringValues);
    }

    public void setElementValue(String elementName, JAnnotation annotationValue) {
        this._elementValues.put(elementName, annotationValue);
    }

    public void setElementValue(String elementName, JAnnotation[] annotationValues) {
        this._elementValues.put(elementName, annotationValues);
    }

    public String getValue() {
        Object elementValue = this.getElementValueObject(value);
        if (elementValue instanceof String) {
            return (String)elementValue;
        }
        throw new IllegalStateException("'value' element is not of type String.");
    }

    public JAnnotation getValueAnnotation() throws IllegalStateException {
        Object elementValue = this.getElementValueObject(value);
        if (elementValue instanceof JAnnotation) {
            return (JAnnotation)elementValue;
        }
        throw new IllegalStateException("'value' element is not of type JAnnotation.");
    }

    public String getElementValue(String elementName) throws IllegalStateException {
        Object elementValue = this.getElementValueObject(elementName);
        if (elementValue instanceof String) {
            return (String)elementValue;
        }
        throw new IllegalStateException("'" + elementName + "' element is not of type String.");
    }

    public String[] getElementValueList(String elementName) throws IllegalStateException {
        Object elementValue = this.getElementValueObject(elementName);
        if (elementValue instanceof String[]) {
            return (String[])elementValue;
        }
        throw new IllegalStateException("'" + elementName + "' element is not of type String[].");
    }

    public Object getElementValueObject(String elementName) {
        return this._elementValues.get(elementName);
    }

    public JAnnotation getElementValueAnnotation(String elementName) throws IllegalStateException {
        Object elementValue = this.getElementValueObject(elementName);
        if (elementValue instanceof JAnnotation) {
            return (JAnnotation)elementValue;
        }
        throw new IllegalStateException("'" + elementName + "' element is not of type JAnnotation.");
    }

    public JAnnotation[] getElementValueAnnotationList(String elementName) throws IllegalStateException {
        Object elementValue = this.getElementValueObject(elementName);
        if (elementValue instanceof JAnnotation[]) {
            return (JAnnotation[])elementValue;
        }
        throw new IllegalStateException("'" + elementName + "' element is not of type JAnnotation[].");
    }

    public String[] getElementNames() {
        return this._elementValues.keySet().toArray(new String[0]);
    }

    public void print(JSourceWriter jsw) {
        jsw.write("@");
        jsw.write(this._annotationType.getLocalName());
        jsw.write("(");
        String[] elementNames = this.getElementNames();
        if (elementNames.length == 1 && elementNames[0].equals(value)) {
            this.printElementValue(jsw, this.getElementValueObject(value));
        } else if (elementNames.length > 0) {
            int elementNameLength;
            int i;
            int maxLength = 0;
            for (i = 0; i < elementNames.length; ++i) {
                elementNameLength = elementNames[i].length();
                if (elementNameLength <= maxLength) continue;
                maxLength = elementNameLength;
            }
            jsw.writeln();
            jsw.indent();
            for (i = 0; i < elementNames.length; ++i) {
                elementNameLength = elementNames[i].length();
                jsw.write(elementNames[i]);
                for (int p = 0; p < maxLength - elementNameLength; ++p) {
                    jsw.write(" ");
                }
                jsw.write(" = ");
                this.printElementValue(jsw, this.getElementValueObject(elementNames[i]));
                if (i >= elementNames.length - 1) continue;
                jsw.write(",");
                jsw.writeln();
            }
            jsw.unindent();
        }
        jsw.write(")");
    }

    private void printElementValue(JSourceWriter jsw, Object elementValue) throws IllegalArgumentException {
        if (elementValue instanceof String) {
            jsw.write((String)elementValue);
            return;
        }
        if (elementValue instanceof JAnnotation) {
            JAnnotation annotation = (JAnnotation)elementValue;
            annotation.print(jsw);
            return;
        }
        if (elementValue.getClass().isArray()) {
            int listLength = Array.getLength(elementValue);
            if (listLength == 1) {
                this.printElementValue(jsw, Array.get(elementValue, 0));
                return;
            }
            jsw.indent();
            jsw.writeln();
            jsw.write("{");
            jsw.writeln();
            jsw.indent();
            for (int i = 0; i < listLength; ++i) {
                this.printElementValue(jsw, Array.get(elementValue, i));
                if (i < listLength - 1) {
                    jsw.write(",");
                }
                jsw.writeln();
            }
            jsw.unindent();
            jsw.write("}");
            jsw.unindent();
            return;
        }
        throw new IllegalArgumentException("'" + elementValue + "' was not expected.");
    }

    public static void main(String[] args) {
        JSourceWriter jsw = new JSourceWriter(new PrintWriter(System.out));
        JAnnotationType requestForEnhancementType = new JAnnotationType("RequestForEnhancement");
        JAnnotation requestForEnhancement = new JAnnotation(requestForEnhancementType);
        requestForEnhancement.setElementValue("id", "2868724");
        requestForEnhancement.setElementValue("sysopsis", "\"Provide time-travel functionality\"");
        requestForEnhancement.setElementValue("enginer", "\"Mr. Peabody\"");
        requestForEnhancement.setElementValue("date", "\"4/1/2004\"");
        requestForEnhancement.print(jsw);
        jsw.writeln();
        jsw.writeln();
        JAnnotationType webMethodType = new JAnnotationType("WebMethod");
        JAnnotation webMethod = new JAnnotation(webMethodType);
        webMethod.print(jsw);
        jsw.writeln();
        jsw.writeln();
        JAnnotationType copyrightType = new JAnnotationType("Copyright");
        JAnnotation copyright = new JAnnotation(copyrightType);
        copyright.setValue("\"2002 Yoyodyne Propulsion Systems, Inc., All rights reserved.\"");
        copyright.print(jsw);
        jsw.writeln();
        jsw.writeln();
        JAnnotationType endorsersType = new JAnnotationType("Endorsers");
        JAnnotation endorsers = new JAnnotation(endorsersType);
        endorsers.setValue(new String[]{"\"Children\"", "\"Unscrupulous dentists\""});
        endorsers.print(jsw);
        jsw.writeln();
        jsw.writeln();
        endorsersType = new JAnnotationType("Endorsers");
        endorsers = new JAnnotation(endorsersType);
        endorsers.setValue(new String[]{"\"Epicurus\""});
        endorsers.print(jsw);
        jsw.writeln();
        jsw.writeln();
        JAnnotationType nameType = new JAnnotationType("Name");
        JAnnotationType authorType = new JAnnotationType("Author");
        JAnnotation author = new JAnnotation(authorType);
        JAnnotation name = new JAnnotation(nameType);
        name.setElementValue("first", "\"Joe\"");
        name.setElementValue("last", "\"Hacker\"");
        author.setValue(name);
        author.print(jsw);
        jsw.writeln();
        jsw.writeln();
        nameType = new JAnnotationType("Name");
        authorType = new JAnnotationType("Author");
        author = new JAnnotation(authorType);
        name = new JAnnotation(nameType);
        name.setElementValue("first", "\"Joe\"");
        name.setElementValue("last", "\"Hacker\"");
        author.setElementValue("name", name);
        author.setElementValue("rating", "Rating.GOOD");
        author.print(jsw);
        jsw.writeln();
        jsw.writeln();
        nameType = new JAnnotationType("Name");
        authorType = new JAnnotationType("Author");
        author = new JAnnotation(authorType);
        JAnnotation name1 = new JAnnotation(nameType);
        name1.setElementValue("first", "\"Joe\"");
        name1.setElementValue("last", "\"Hacker\"");
        JAnnotation name2 = new JAnnotation(nameType);
        name2.setElementValue("first", "\"Joe\"");
        name2.setElementValue("last", "\"Blogs\"");
        author.setElementValue("name", new JAnnotation[]{name1, name2});
        author.setElementValue("rating", "Rating.GOOD");
        author.print(jsw);
        jsw.flush();
    }
}

