/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.property;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.maskat.framework.eventdef.Event;
import org.maskat.framework.eventdef.Header;
import org.maskat.ide.property.descriptor.HeaderPropertyDescriptor;

public class HeadersProperty implements IPropertySource {

	private Event evt;

	public HeadersProperty(Event event) {
		this.evt = event;
	}

	public Object getEditableValue() {
		return this;
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		List headersPropDesc = new ArrayList();
		int i = 0;
		for (Iterator it = evt.getTypedChildren(Header.class); it != null && it.hasNext(); i++) {
			it.next();
			headersPropDesc.add(new HeaderPropertyDescriptor(new Integer(i), "header"));
		}

		return (IPropertyDescriptor[]) headersPropDesc
				.toArray(new IPropertyDescriptor[headersPropDesc.size()]);
	}

	public Object getPropertyValue(Object id) {
		if (id instanceof Integer) {
			int idx = ((Integer) id).intValue();
			return evt.getChildByTypeIdx(HeaderProperty.class, idx);
		}
		return null;
	}

	public boolean isPropertySet(Object id) {
		return false;
	}

	public void resetPropertyValue(Object id) {
	}

	public void setPropertyValue(Object id, Object value) {
	}

	public void addHeader(Header header) {
		evt.addChild(header);
	}

	public void removeHeader(Header header) {
		evt.removeChild(header);
	}

	public String toString() {
		return "";
	}
}
