/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.models;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import org.maskat.framework.screendef.IContainerDef;

public class SplitModel {

	private int thickness;

	private IContainerDef parent;

	private int x, y, width, height;

	public SplitModel(IContainerDef parent, int thickness) {
		this.parent = parent;
		this.thickness = thickness;
	}

	public int getThickness() {
		return thickness;
	}

	public void setThickness(int thickness) {
		this.thickness = thickness;
	}

	public IContainerDef getParent() {
		return parent;
	}

	public void setParent(IContainerDef parent) {
		this.parent = parent;
	}

	public int getHeight() {
		return height;
	}

	public void setHeight(int height) {
		this.height = height;
		firePropertyChange("constraint", "", null);
	}

	public int getWidth() {
		return width;
	}

	public void setWidth(int width) {
		this.width = width;
		firePropertyChange("constraint", "", null);
	}

	public int getX() {
		return x;
	}

	public void setX(int x) {
		this.x = x;
		firePropertyChange("constraint", "", null);
	}

	public int getY() {
		return y;
	}

	public void setY(int y) {
		this.y = y;
		firePropertyChange("constraint", "", null);
	}

	// f̏ԕωʒm郊XĩXg
	private PropertyChangeSupport listeners = new PropertyChangeSupport(this);

	public void addPropertyChangeListener(PropertyChangeListener l) {
		listeners.addPropertyChangeListener(l);
	}

	protected void firePropertyChange(String propName, Object oldValue,
			Object newValue) {
		listeners.firePropertyChange(propName, oldValue, newValue);
	}

	public void removePropertyChangeListener(PropertyChangeListener l) {
		listeners.removePropertyChangeListener(l);
	}
}
