/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.maskat.framework.screendef.ComponentDef;
import org.maskat.framework.screendef.DivSplitDef;
import org.maskat.framework.screendef.IComponentDef;
import org.maskat.framework.screendef.SplitterDef;
import org.maskat.ide.gef.editpolicies.MaskatComponentEditPolicy;
import org.maskat.ide.gef.editpolicies.MyXYLayoutEditPolicy;
import org.maskat.ide.gef.figure.SplitterFigure;
import org.maskat.ide.gef.models.SplitModel;

public class SplitterEditPart extends AbstractGraphicalEditPart implements
		PropertyChangeListener {

	private int currentSelectedSplitIdx = 0;// 0ԖڂdivSplit͏\

	// spliť()
	private int splitThickness = 8;

	public int getCurrentSelectedSplitIdx() {
		return currentSelectedSplitIdx;
	}

	public void activate() {
		super.activate();
		ComponentDef model = (ComponentDef) getModel();
		model.addPropertyChangeListener(this);
	}

	public void deactivate() {
		ComponentDef model = (ComponentDef) getModel();
		model.removePropertyChangeListener(this);
		super.deactivate();
	}

	protected IFigure createFigure() {
		SplitterFigure splitterFig = new SplitterFigure();
		XYLayout layout = new XYLayout();
		splitterFig.setLayoutManager(layout);
		splitterFig.setBorder(new CompoundBorder(new LineBorder(), new MarginBorder(0)));

		return splitterFig;
	}

	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.COMPONENT_ROLE, new MaskatComponentEditPolicy());
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new MyXYLayoutEditPolicy());
	}

	private SplitModel split;

	protected List getModelChildren() {
		SplitterDef splitterDef = (SplitterDef) getModel();
		List children = splitterDef.getComponentChildren();
		List result = new ArrayList();
		for (Iterator it = children.iterator(); it.hasNext();) {
			DivSplitDef divSplit = (DivSplitDef) it.next();
			result.add(divSplit);
		}

		split = new SplitModel(splitterDef, splitThickness);
		result.add(split);

		calcSplitSize();
		calcDivSplitSize();

		return result;
	}

	protected void refreshVisuals() {
		// ̎擾
		IComponentDef comp = (IComponentDef) getModel();
		Rectangle constraint = new Rectangle(comp.getLeft(), comp.getTop(), comp
				.getWidth(), comp.getHeight());

		// RectangleIuWFNg𐧖Ƃăr[ɐݒ肷
		// setLayoutConstraint\bh͐eEditPartĂяo
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);
	}

	public void doSwitch() {
		currentSelectedSplitIdx = 1 - currentSelectedSplitIdx;// 0,1؂ւ
		calcSplitSize();

		for (int i = 0; i < getChildren().size(); i++) {
			AbstractGraphicalEditPart editPart = (AbstractGraphicalEditPart) getChildren()
					.get(i);
			if (editPart instanceof SplitEditPart) {
				this.setLayoutConstraint(editPart, editPart.getFigure(), new Rectangle(
						split.getX(), split.getY(), split.getWidth(), split.getHeight()));
			}
		}
	}

	private void calcSplitSize() {
		SplitterDef splitterDef = (SplitterDef) getModel();
		boolean isHorizontal = splitterDef.isHorizontal();
		if (isHorizontal) {
			split.setWidth(splitThickness);
			split.setHeight(splitterDef.getHeight() - 1);
			split.setY(0);
			if (currentSelectedSplitIdx == 0) {
				split.setX(splitterDef.getWidth() - splitThickness - 1);
			} else {
				split.setX(0);
			}
		} else {
			// vertical
			split.setWidth(splitterDef.getWidth() - 1);
			split.setHeight(splitThickness);
			split.setX(0);
			if (currentSelectedSplitIdx == 0) {
				split.setY(splitterDef.getHeight() - splitThickness - 1);
			} else {
				split.setY(0);
			}
		}
	}

	private void calcDivSplitSize() {
		SplitterDef splitterDef = (SplitterDef) getModel();
		boolean isHorizontal = splitterDef.isHorizontal();
		DivSplitDef div0 = (DivSplitDef) splitterDef.getChildByTypeIdx(DivSplitDef.class,
				0);
		DivSplitDef div1 = (DivSplitDef) splitterDef.getChildByTypeIdx(DivSplitDef.class,
				1);
		if (isHorizontal) {
			if (div0 != null) {
				// l
				div0.setLeft(0);
				div0.setTop(0);
				div0.setWidth(splitterDef.getWidth() - splitThickness - 1);
				div0.setHeight(splitterDef.getHeight() - 1);
			}
			if (div1 != null) {
				// El
				div1.setLeft(splitThickness);
				div1.setTop(0);
				div1.setWidth(splitterDef.getWidth() - splitThickness - 1);
				div1.setHeight(splitterDef.getHeight() - 1);
			}
		} else {
			if (div0 != null) {
				// l
				div0.setLeft(0);
				div0.setTop(0);
				div0.setWidth(splitterDef.getWidth() - 1);
				div0.setHeight(splitterDef.getHeight() - splitThickness - 1);
			}
			if (div1 != null) {
				// l
				div1.setLeft(0);
				div1.setTop(splitThickness);
				div1.setWidth(splitterDef.getWidth() - 1);
				div1.setHeight(splitterDef.getHeight() - splitThickness - 1);
			}
		}
	}

	public void propertyChange(PropertyChangeEvent evt) {
		calcSplitSize();
		calcDivSplitSize();
		refreshVisuals();
	}
}